/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.utils.immersionbar;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.FrameLayout;
import androidx.drawerlayout.widget.DrawerLayout;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarConfig;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarHide;
import com.maning.imagebrowserlibrary.utils.immersionbar.ImmersionBar;

class FitsKeyboard
implements ViewTreeObserver.OnGlobalLayoutListener {
    private int mStatusBarHeight;
    private int mActionBarHeight;
    private ImmersionBar mImmersionBar;
    private Activity mActivity;
    private Window mWindow;
    private View mDecorView;
    private View mContentView;
    private View mChildView;
    private int mPaddingLeft = 0;
    private int mPaddingTop = 0;
    private int mPaddingRight = 0;
    private int mPaddingBottom = 0;
    private int mTempKeyboardHeight;
    private boolean mIsAddListener;

    FitsKeyboard(ImmersionBar immersionBar, Activity activity, Window window) {
        this.mImmersionBar = immersionBar;
        this.mActivity = activity;
        this.mWindow = window;
        this.mDecorView = this.mWindow.getDecorView();
        FrameLayout frameLayout = (FrameLayout)this.mDecorView.findViewById(0x1020002);
        this.mChildView = frameLayout.getChildAt(0);
        if (this.mChildView != null) {
            if (this.mChildView instanceof DrawerLayout) {
                this.mChildView = ((DrawerLayout)this.mChildView).getChildAt(0);
            }
            if (this.mChildView != null) {
                this.mPaddingLeft = this.mChildView.getPaddingLeft();
                this.mPaddingTop = this.mChildView.getPaddingTop();
                this.mPaddingRight = this.mChildView.getPaddingRight();
                this.mPaddingBottom = this.mChildView.getPaddingBottom();
            }
        }
        this.mContentView = this.mChildView != null ? this.mChildView : frameLayout;
        BarConfig barConfig = new BarConfig(this.mActivity);
        this.mStatusBarHeight = barConfig.getStatusBarHeight();
        this.mActionBarHeight = barConfig.getActionBarHeight();
    }

    void enable(int mode) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.mWindow.setSoftInputMode(mode);
            if (!this.mIsAddListener) {
                this.mDecorView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                this.mIsAddListener = true;
            }
        }
    }

    void updateBarConfig(BarConfig barConfig) {
        this.mStatusBarHeight = barConfig.getStatusBarHeight();
        if (this.mImmersionBar != null && this.mImmersionBar.isActionBarBelowLOLLIPOP()) {
            this.mActionBarHeight = barConfig.getActionBarHeight();
        }
    }

    void disable() {
        if (Build.VERSION.SDK_INT >= 19 && this.mIsAddListener) {
            if (this.mChildView != null) {
                this.mContentView.setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
            } else {
                this.mContentView.setPadding(this.mImmersionBar.getPaddingLeft(), this.mImmersionBar.getPaddingTop(), this.mImmersionBar.getPaddingRight(), this.mImmersionBar.getPaddingBottom());
            }
        }
    }

    void cancel() {
        if (Build.VERSION.SDK_INT >= 19 && this.mIsAddListener) {
            this.mDecorView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            this.mIsAddListener = false;
        }
    }

    public void onGlobalLayout() {
        if (this.mImmersionBar != null && this.mImmersionBar.getBarParams() != null && this.mImmersionBar.getBarParams().keyboardEnable) {
            int bottom = 0;
            int navigationBarHeight = ImmersionBar.getNavigationBarHeight(this.mActivity);
            boolean isPopup = false;
            Rect rect = new Rect();
            this.mDecorView.getWindowVisibleDisplayFrame(rect);
            int keyboardHeight = this.mContentView.getHeight() - rect.bottom;
            if (keyboardHeight != this.mTempKeyboardHeight) {
                this.mTempKeyboardHeight = keyboardHeight;
                if (!ImmersionBar.checkFitsSystemWindows(this.mWindow.getDecorView().findViewById(0x1020002))) {
                    if (this.mChildView != null) {
                        if (this.mImmersionBar.getBarParams().isSupportActionBar) {
                            keyboardHeight += this.mActionBarHeight + this.mStatusBarHeight;
                        }
                        if (this.mImmersionBar.getBarParams().fits) {
                            keyboardHeight += this.mStatusBarHeight;
                        }
                        if (keyboardHeight > navigationBarHeight) {
                            bottom = keyboardHeight + this.mPaddingBottom;
                            isPopup = true;
                        }
                        this.mContentView.setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, bottom);
                    } else {
                        bottom = this.mImmersionBar.getPaddingBottom();
                        if ((keyboardHeight -= navigationBarHeight) > navigationBarHeight) {
                            bottom = keyboardHeight + navigationBarHeight;
                            isPopup = true;
                        }
                        this.mContentView.setPadding(this.mImmersionBar.getPaddingLeft(), this.mImmersionBar.getPaddingTop(), this.mImmersionBar.getPaddingRight(), bottom);
                    }
                } else if ((keyboardHeight -= navigationBarHeight) > navigationBarHeight) {
                    isPopup = true;
                }
                if (keyboardHeight < 0) {
                    keyboardHeight = 0;
                }
                if (this.mImmersionBar.getBarParams().onKeyboardListener != null) {
                    this.mImmersionBar.getBarParams().onKeyboardListener.onKeyboardChange(isPopup, keyboardHeight);
                }
                if (!isPopup && this.mImmersionBar.getBarParams().barHide != BarHide.FLAG_SHOW_BAR) {
                    this.mImmersionBar.setBar();
                }
            }
        }
    }
}

