/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.utils.immersionbar;

import android.app.Application;
import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import com.maning.imagebrowserlibrary.utils.immersionbar.ImmersionCallback;
import java.util.ArrayList;

final class EMUI3NavigationBarObserver
extends ContentObserver {
    private ArrayList<ImmersionCallback> mCallbacks;
    private Application mApplication;
    private Boolean mIsRegister = false;

    static EMUI3NavigationBarObserver getInstance() {
        return NavigationBarObserverInstance.INSTANCE;
    }

    private EMUI3NavigationBarObserver() {
        super(new Handler(Looper.getMainLooper()));
    }

    void register(Application application) {
        Uri uri;
        this.mApplication = application;
        if (Build.VERSION.SDK_INT >= 17 && this.mApplication != null && this.mApplication.getContentResolver() != null && !this.mIsRegister.booleanValue() && (uri = Settings.System.getUriFor((String)"navigationbar_is_min")) != null) {
            this.mApplication.getContentResolver().registerContentObserver(uri, true, (ContentObserver)this);
            this.mIsRegister = true;
        }
    }

    public void onChange(boolean selfChange) {
        super.onChange(selfChange);
        if (Build.VERSION.SDK_INT >= 17 && this.mApplication != null && this.mApplication.getContentResolver() != null && this.mCallbacks != null && !this.mCallbacks.isEmpty()) {
            int show = Settings.System.getInt((ContentResolver)this.mApplication.getContentResolver(), (String)"navigationbar_is_min", (int)0);
            for (ImmersionCallback callback : this.mCallbacks) {
                callback.onNavigationBarChange(show != 1);
            }
        }
    }

    void addOnNavigationBarListener(ImmersionCallback callback) {
        if (callback == null) {
            return;
        }
        if (this.mCallbacks == null) {
            this.mCallbacks = new ArrayList();
        }
        if (!this.mCallbacks.contains(callback)) {
            this.mCallbacks.add(callback);
        }
    }

    void removeOnNavigationBarListener(ImmersionCallback callback) {
        if (callback == null || this.mCallbacks == null) {
            return;
        }
        this.mCallbacks.remove(callback);
    }

    private static class NavigationBarObserverInstance {
        private static final EMUI3NavigationBarObserver INSTANCE = new EMUI3NavigationBarObserver();

        private NavigationBarObserverInstance() {
        }
    }
}

