/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary.utils.immersionbar;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.WindowManager;
import com.maning.imagebrowserlibrary.R;
import com.maning.imagebrowserlibrary.utils.immersionbar.OSUtils;

class BarConfig {
    private final int mStatusBarHeight;
    private final int mActionBarHeight;
    private final boolean mHasNavigationBar;
    private final int mNavigationBarHeight;
    private final int mNavigationBarWidth;
    private final boolean mInPortrait;
    private final float mSmallestWidthDp;

    BarConfig(Activity activity) {
        Resources res = activity.getResources();
        this.mInPortrait = res.getConfiguration().orientation == 1;
        this.mSmallestWidthDp = this.getSmallestWidthDp(activity);
        this.mStatusBarHeight = this.getInternalDimensionSize((Context)activity, "status_bar_height");
        this.mActionBarHeight = this.getActionBarHeight(activity);
        this.mNavigationBarHeight = this.getNavigationBarHeight((Context)activity);
        this.mNavigationBarWidth = this.getNavigationBarWidth((Context)activity);
        this.mHasNavigationBar = this.mNavigationBarHeight > 0;
    }

    @TargetApi(value=14)
    private int getActionBarHeight(Activity activity) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14) {
            View actionBar = activity.getWindow().findViewById(R.id.action_bar_container);
            if (actionBar != null) {
                result = actionBar.getMeasuredHeight();
            }
            if (result == 0) {
                TypedValue tv = new TypedValue();
                activity.getTheme().resolveAttribute(16843499, tv, true);
                result = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)activity.getResources().getDisplayMetrics());
            }
        }
        return result;
    }

    @TargetApi(value=14)
    private int getNavigationBarHeight(Context context) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14 && this.hasNavBar((Activity)context)) {
            String key = this.mInPortrait ? "navigation_bar_height" : "navigation_bar_height_landscape";
            return this.getInternalDimensionSize(context, key);
        }
        return result;
    }

    @TargetApi(value=14)
    private int getNavigationBarWidth(Context context) {
        int result = 0;
        if (Build.VERSION.SDK_INT >= 14 && this.hasNavBar((Activity)context)) {
            return this.getInternalDimensionSize(context, "navigation_bar_width");
        }
        return result;
    }

    @TargetApi(value=14)
    private boolean hasNavBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 17) {
            if (Settings.Global.getInt((ContentResolver)activity.getContentResolver(), (String)"force_fsg_nav_bar", (int)0) != 0) {
                return false;
            }
            if (OSUtils.isEMUI() && (OSUtils.isEMUI3_x() || Build.VERSION.SDK_INT < 21 ? Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"navigationbar_is_min", (int)0) != 0 : Settings.Global.getInt((ContentResolver)activity.getContentResolver(), (String)"navigationbar_is_min", (int)0) != 0)) {
                return false;
            }
        }
        WindowManager windowManager = activity.getWindowManager();
        Display d = windowManager.getDefaultDisplay();
        DisplayMetrics realDisplayMetrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 17) {
            d.getRealMetrics(realDisplayMetrics);
        }
        int realHeight = realDisplayMetrics.heightPixels;
        int realWidth = realDisplayMetrics.widthPixels;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        d.getMetrics(displayMetrics);
        int displayHeight = displayMetrics.heightPixels;
        int displayWidth = displayMetrics.widthPixels;
        return realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
    }

    private int getInternalDimensionSize(Context context, String key) {
        int result = 0;
        try {
            int resourceId = Resources.getSystem().getIdentifier(key, "dimen", "android");
            if (resourceId > 0) {
                int sizeOne = context.getResources().getDimensionPixelSize(resourceId);
                int sizeTwo = Resources.getSystem().getDimensionPixelSize(resourceId);
                if (sizeTwo >= sizeOne) {
                    return sizeTwo;
                }
                float densityTwo = Resources.getSystem().getDisplayMetrics().density;
                float densityOne = context.getResources().getDisplayMetrics().density;
                float f = (float)sizeOne * densityTwo / densityOne;
                return (int)(f >= 0.0f ? f + 0.5f : f - 0.5f);
            }
        }
        catch (Resources.NotFoundException ignored) {
            return 0;
        }
        return result;
    }

    @SuppressLint(value={"NewApi"})
    private float getSmallestWidthDp(Activity activity) {
        DisplayMetrics metrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT >= 16) {
            activity.getWindowManager().getDefaultDisplay().getRealMetrics(metrics);
        } else {
            activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        }
        float widthDp = (float)metrics.widthPixels / metrics.density;
        float heightDp = (float)metrics.heightPixels / metrics.density;
        return Math.min(widthDp, heightDp);
    }

    boolean isNavigationAtBottom() {
        return this.mSmallestWidthDp >= 600.0f || this.mInPortrait;
    }

    int getStatusBarHeight() {
        return this.mStatusBarHeight;
    }

    int getActionBarHeight() {
        return this.mActionBarHeight;
    }

    boolean hasNavigationBar() {
        return this.mHasNavigationBar;
    }

    int getNavigationBarHeight() {
        return this.mNavigationBarHeight;
    }

    int getNavigationBarWidth() {
        return this.mNavigationBarWidth;
    }
}

