/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.maning.imagebrowserlibrary.ImageEngine;
import com.maning.imagebrowserlibrary.R;
import com.maning.imagebrowserlibrary.listeners.OnClickListener;
import com.maning.imagebrowserlibrary.listeners.OnLongClickListener;
import com.maning.imagebrowserlibrary.listeners.OnPageChangeListener;
import com.maning.imagebrowserlibrary.model.ImageBrowserConfig;
import com.maning.imagebrowserlibrary.transforms.DefaultTransformer;
import com.maning.imagebrowserlibrary.transforms.DepthPageTransformer;
import com.maning.imagebrowserlibrary.transforms.RotateDownTransformer;
import com.maning.imagebrowserlibrary.transforms.RotateUpTransformer;
import com.maning.imagebrowserlibrary.transforms.ZoomInTransformer;
import com.maning.imagebrowserlibrary.transforms.ZoomOutSlideTransformer;
import com.maning.imagebrowserlibrary.transforms.ZoomOutTransformer;
import com.maning.imagebrowserlibrary.utils.immersionbar.BarHide;
import com.maning.imagebrowserlibrary.utils.immersionbar.ImmersionBar;
import com.maning.imagebrowserlibrary.view.CircleIndicator;
import com.maning.imagebrowserlibrary.view.MNGestureView;
import com.maning.imagebrowserlibrary.view.MNViewPager;
import com.maning.imagebrowserlibrary.view.photoview.PhotoView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class MNImageBrowserActivity
extends AppCompatActivity {
    private static WeakReference<MNImageBrowserActivity> sActivityRef;
    public static ImageBrowserConfig imageBrowserConfig;
    private Context context;
    private MNGestureView mnGestureView;
    private MNViewPager viewPagerBrowser;
    private RelativeLayout rl_black_bg;
    private RelativeLayout rl_indicator;
    private TextView numberIndicator;
    private CircleIndicator circleIndicator;
    private LinearLayout ll_custom_view;
    private FrameLayout fl_out;
    private ArrayList<String> imageUrlList;
    private int currentPosition;
    private ImageBrowserConfig.TransformType transformType;
    private ImageBrowserConfig.IndicatorType indicatorType;
    public ImageEngine imageEngine;
    public OnLongClickListener onLongClickListener;
    public OnClickListener onClickListener;
    public OnPageChangeListener onPageChangeListener;
    private MyAdapter imageBrowserAdapter;
    private ImageBrowserConfig.ScreenOrientationType screenOrientationType;
    private int progressViewLayoutId = 0;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.setContentView(R.layout.activity_mnimage_browser);
            sActivityRef = new WeakReference<MNImageBrowserActivity>(this);
            this.context = this;
            this.getImageBrowserConfig();
            this.initBar();
            this.initViews();
            this.initData();
            this.initViewPager();
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)">>MNImageBrowser>>", (String)("MNImageBrowserActivity-onCreate\u5f02\u5e38\uff1a" + e.toString()));
            this.finishBrowser();
        }
    }

    private void initBar() {
        try {
            ImmersionBar.with((Activity)this).navigationBarColor(R.color.mn_ib_black).init();
            if (this.getImageBrowserConfig().isFullScreenMode()) {
                ImmersionBar.with((Activity)this).hideBar(BarHide.FLAG_HIDE_STATUS_BAR).init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.e((String)">>MNImageBrowser>>", (String)("MNImageBrowserActivity-initBar\u5f02\u5e38\uff1a" + e.toString()));
        }
    }

    private void initViews() {
        this.viewPagerBrowser = (MNViewPager)this.findViewById(R.id.viewPagerBrowser);
        this.mnGestureView = (MNGestureView)this.findViewById(R.id.mnGestureView);
        this.rl_black_bg = (RelativeLayout)this.findViewById(R.id.rl_black_bg);
        this.rl_indicator = (RelativeLayout)this.findViewById(R.id.rl_indicator);
        this.circleIndicator = (CircleIndicator)this.findViewById(R.id.circleIndicator);
        this.numberIndicator = (TextView)this.findViewById(R.id.numberIndicator);
        this.ll_custom_view = (LinearLayout)this.findViewById(R.id.ll_custom_view);
        this.fl_out = (FrameLayout)this.findViewById(R.id.fl_out);
        this.circleIndicator.setVisibility(8);
        this.numberIndicator.setVisibility(8);
        this.ll_custom_view.setVisibility(8);
    }

    private ImageBrowserConfig getImageBrowserConfig() {
        if (imageBrowserConfig == null) {
            imageBrowserConfig = new ImageBrowserConfig();
        }
        return imageBrowserConfig;
    }

    private void initData() {
        this.imageUrlList = this.getImageBrowserConfig().getImageList();
        this.currentPosition = this.getImageBrowserConfig().getPosition();
        this.transformType = this.getImageBrowserConfig().getTransformType();
        this.imageEngine = this.getImageBrowserConfig().getImageEngine();
        this.onClickListener = this.getImageBrowserConfig().getOnClickListener();
        this.onLongClickListener = this.getImageBrowserConfig().getOnLongClickListener();
        this.indicatorType = this.getImageBrowserConfig().getIndicatorType();
        this.screenOrientationType = this.getImageBrowserConfig().getScreenOrientationType();
        this.onPageChangeListener = this.getImageBrowserConfig().getOnPageChangeListener();
        if (this.imageUrlList == null) {
            this.imageUrlList = new ArrayList();
            MNImageBrowserActivity.finishActivity();
            return;
        }
        if (this.imageUrlList.size() <= 1) {
            this.rl_indicator.setVisibility(8);
        } else {
            this.rl_indicator.setVisibility(0);
            if (this.getImageBrowserConfig().isIndicatorHide()) {
                this.rl_indicator.setVisibility(8);
            } else {
                this.rl_indicator.setVisibility(0);
            }
            if (this.indicatorType == ImageBrowserConfig.IndicatorType.Indicator_Number) {
                this.numberIndicator.setVisibility(0);
                this.numberIndicator.setText((CharSequence)(this.currentPosition + 1 + "/" + this.imageUrlList.size()));
            } else {
                this.circleIndicator.setVisibility(0);
            }
        }
        View customShadeView = this.getImageBrowserConfig().getCustomShadeView();
        if (customShadeView != null) {
            this.ll_custom_view.setVisibility(0);
            this.ll_custom_view.removeAllViews();
            this.ll_custom_view.addView(customShadeView);
            this.rl_indicator.setVisibility(8);
        }
        if (this.screenOrientationType == ImageBrowserConfig.ScreenOrientationType.ScreenOrientation_Portrait) {
            this.setRequestedOrientation(1);
        } else if (this.screenOrientationType == ImageBrowserConfig.ScreenOrientationType.Screenorientation_Landscape) {
            this.setRequestedOrientation(0);
        } else {
            this.setRequestedOrientation(4);
        }
        this.progressViewLayoutId = this.getImageBrowserConfig().getCustomProgressViewLayoutID();
    }

    private void initViewPager() {
        this.imageBrowserAdapter = new MyAdapter();
        this.viewPagerBrowser.setAdapter(this.imageBrowserAdapter);
        this.viewPagerBrowser.setCurrentItem(this.currentPosition);
        this.setViewPagerTransforms();
        this.circleIndicator.setViewPager(this.viewPagerBrowser);
        this.viewPagerBrowser.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                MNImageBrowserActivity.this.currentPosition = position;
                MNImageBrowserActivity.this.numberIndicator.setText((CharSequence)(MNImageBrowserActivity.this.currentPosition + 1 + "/" + MNImageBrowserActivity.this.imageUrlList.size()));
                if (MNImageBrowserActivity.this.onPageChangeListener != null) {
                    MNImageBrowserActivity.this.onPageChangeListener.onPageSelected(position);
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mnGestureView.setOnGestureListener(new MNGestureView.OnCanSwipeListener(){

            @Override
            public boolean canSwipe() {
                if (Build.VERSION.SDK_INT == 26) {
                    return false;
                }
                if (!MNImageBrowserActivity.this.getImageBrowserConfig().isOpenPullDownGestureEffect()) {
                    return false;
                }
                View view = MNImageBrowserActivity.this.imageBrowserAdapter.getPrimaryItem();
                PhotoView imageView = (PhotoView)view.findViewById(R.id.imageView);
                return (double)imageView.getScale() == 1.0;
            }
        });
        this.mnGestureView.setOnSwipeListener(new MNGestureView.OnSwipeListener(){

            @Override
            public void downSwipe() {
                MNImageBrowserActivity.this.finishBrowser();
            }

            @Override
            public void onSwiping(float deltaY) {
                MNImageBrowserActivity.this.rl_indicator.setVisibility(8);
                MNImageBrowserActivity.this.ll_custom_view.setVisibility(8);
                float mAlpha = 1.0f - deltaY / 500.0f;
                if ((double)mAlpha < 0.3) {
                    mAlpha = 0.3f;
                }
                if (mAlpha > 1.0f) {
                    mAlpha = 1.0f;
                }
                MNImageBrowserActivity.this.rl_black_bg.setAlpha(mAlpha);
            }

            @Override
            public void overSwipe() {
                if (MNImageBrowserActivity.this.imageUrlList.size() <= 1) {
                    MNImageBrowserActivity.this.rl_indicator.setVisibility(8);
                } else {
                    MNImageBrowserActivity.this.rl_indicator.setVisibility(0);
                    if (!MNImageBrowserActivity.this.getImageBrowserConfig().isIndicatorHide()) {
                        MNImageBrowserActivity.this.rl_indicator.setVisibility(0);
                    } else {
                        MNImageBrowserActivity.this.rl_indicator.setVisibility(8);
                    }
                }
                View customShadeView = MNImageBrowserActivity.this.getImageBrowserConfig().getCustomShadeView();
                if (customShadeView != null) {
                    MNImageBrowserActivity.this.ll_custom_view.setVisibility(0);
                    MNImageBrowserActivity.this.rl_indicator.setVisibility(8);
                } else {
                    MNImageBrowserActivity.this.ll_custom_view.setVisibility(8);
                }
                MNImageBrowserActivity.this.rl_black_bg.setAlpha(1.0f);
            }
        });
    }

    private void setViewPagerTransforms() {
        if (this.transformType == ImageBrowserConfig.TransformType.Transform_Default) {
            this.viewPagerBrowser.setPageTransformer(true, new DefaultTransformer());
        } else if (this.transformType == ImageBrowserConfig.TransformType.Transform_DepthPage) {
            this.viewPagerBrowser.setPageTransformer(true, new DepthPageTransformer());
        } else if (this.transformType == ImageBrowserConfig.TransformType.Transform_RotateDown) {
            this.viewPagerBrowser.setPageTransformer(true, new RotateDownTransformer());
        } else if (this.transformType == ImageBrowserConfig.TransformType.Transform_RotateUp) {
            this.viewPagerBrowser.setPageTransformer(true, new RotateUpTransformer());
        } else if (this.transformType == ImageBrowserConfig.TransformType.Transform_ZoomIn) {
            this.viewPagerBrowser.setPageTransformer(true, new ZoomInTransformer());
        } else if (this.transformType == ImageBrowserConfig.TransformType.Transform_ZoomOutSlide) {
            this.viewPagerBrowser.setPageTransformer(true, new ZoomOutSlideTransformer());
        } else if (this.transformType == ImageBrowserConfig.TransformType.Transform_ZoomOut) {
            this.viewPagerBrowser.setPageTransformer(true, new ZoomOutTransformer());
        } else {
            this.viewPagerBrowser.setPageTransformer(true, new DefaultTransformer());
        }
    }

    private void finishBrowser() {
        try {
            this.getWindow().clearFlags(1024);
            this.ll_custom_view.setVisibility(8);
            this.rl_indicator.setVisibility(8);
            this.finish();
            this.overridePendingTransition(0, this.getImageBrowserConfig().getActivityExitAnime());
            sActivityRef = null;
            imageBrowserConfig = null;
        }
        catch (Exception e) {
            this.finish();
        }
    }

    public void onBackPressed() {
        this.finishBrowser();
    }

    public static FragmentActivity getCurrentActivity() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            return (FragmentActivity)sActivityRef.get();
        }
        return null;
    }

    public static void finishActivity() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            ((MNImageBrowserActivity)((Object)sActivityRef.get())).finishBrowser();
        }
    }

    public static ViewPager getViewPager() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            return ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).viewPagerBrowser;
        }
        return null;
    }

    public static int getCurrentPosition() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            return ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).currentPosition;
        }
        return -1;
    }

    public static ImageView getCurrentImageView() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            MyAdapter imageBrowserAdapter = ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).imageBrowserAdapter;
            if (imageBrowserAdapter == null) {
                return null;
            }
            View view = imageBrowserAdapter.getPrimaryItem();
            if (view == null) {
                return null;
            }
            PhotoView imageView = (PhotoView)view.findViewById(R.id.imageView);
            return imageView;
        }
        return null;
    }

    public static void removeImage(int position) {
        if (sActivityRef != null && sActivityRef.get() != null && ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).imageUrlList.size() > 1) {
            ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).imageUrlList.remove(position);
            if (((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).currentPosition >= ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).imageUrlList.size() && ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).currentPosition >= 1) {
                --((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).currentPosition;
            }
            if (((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).currentPosition >= ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).imageUrlList.size()) {
                ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).currentPosition = ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).imageUrlList.size() - 1;
            }
            ((MNImageBrowserActivity)((Object)sActivityRef.get())).initViewPager();
            ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).imageBrowserAdapter.notifyDataSetChanged();
        }
    }

    public static void removeCurrentImage() {
        MNImageBrowserActivity.removeImage(MNImageBrowserActivity.getCurrentPosition());
    }

    public static ArrayList<String> getImageList() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            return ((MNImageBrowserActivity)((Object)MNImageBrowserActivity.sActivityRef.get())).imageUrlList;
        }
        return new ArrayList<String>();
    }

    private class MyAdapter
    extends PagerAdapter {
        private View mCurrentView;
        private LayoutInflater layoutInflater;

        public MyAdapter() {
            this.layoutInflater = LayoutInflater.from((Context)MNImageBrowserActivity.this.context);
        }

        public void setPrimaryItem(ViewGroup container, int position, Object object) {
            this.mCurrentView = (View)object;
        }

        public View getPrimaryItem() {
            return this.mCurrentView;
        }

        public int getCount() {
            return MNImageBrowserActivity.this.imageUrlList.size();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public Object instantiateItem(ViewGroup container, final int position) {
            View inflate = this.layoutInflater.inflate(R.layout.mn_image_browser_item_show_image, container, false);
            final PhotoView imageView = (PhotoView)inflate.findViewById(R.id.imageView);
            RelativeLayout rl_browser_root = (RelativeLayout)inflate.findViewById(R.id.rl_browser_root);
            RelativeLayout progress_view = (RelativeLayout)inflate.findViewById(R.id.progress_view);
            final String url = (String)MNImageBrowserActivity.this.imageUrlList.get(position);
            rl_browser_root.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MNImageBrowserActivity.this.finishBrowser();
                }
            });
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (MNImageBrowserActivity.this.onClickListener != null) {
                        MNImageBrowserActivity.this.onClickListener.onClick((FragmentActivity)MNImageBrowserActivity.this, (ImageView)imageView, position, url);
                    }
                    MNImageBrowserActivity.this.finishBrowser();
                }
            });
            imageView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    if (MNImageBrowserActivity.this.onLongClickListener != null) {
                        MNImageBrowserActivity.this.onLongClickListener.onLongClick((FragmentActivity)MNImageBrowserActivity.this, (ImageView)imageView, position, url);
                    }
                    return false;
                }
            });
            if (MNImageBrowserActivity.this.progressViewLayoutId != 0) {
                View customProgressView = this.layoutInflater.inflate(MNImageBrowserActivity.this.progressViewLayoutId, null);
                if (customProgressView != null) {
                    progress_view.removeAllViews();
                    progress_view.addView(customProgressView);
                    progress_view.setVisibility(0);
                } else {
                    progress_view.setVisibility(8);
                }
            } else {
                progress_view.setVisibility(8);
            }
            MNImageBrowserActivity.this.imageEngine.loadImage(MNImageBrowserActivity.this.context, url, (ImageView)imageView, (View)progress_view);
            container.addView(inflate);
            return inflate;
        }
    }
}

