/*
 * Decompiled with CFR 0.152.
 */
package com.maning.imagebrowserlibrary;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.AnimRes;
import androidx.annotation.LayoutRes;
import androidx.core.app.ActivityCompat;
import androidx.core.app.ActivityOptionsCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.viewpager.widget.ViewPager;
import com.maning.imagebrowserlibrary.ImageEngine;
import com.maning.imagebrowserlibrary.MNImageBrowserActivity;
import com.maning.imagebrowserlibrary.R;
import com.maning.imagebrowserlibrary.listeners.OnClickListener;
import com.maning.imagebrowserlibrary.listeners.OnLongClickListener;
import com.maning.imagebrowserlibrary.listeners.OnPageChangeListener;
import com.maning.imagebrowserlibrary.model.ImageBrowserConfig;
import com.maning.imagebrowserlibrary.utils.FastClickUtils;
import java.util.ArrayList;

public class MNImageBrowser {
    private Context context;
    private ImageBrowserConfig imageBrowserConfig;

    private MNImageBrowser(Context context) {
        this.context = context;
        this.imageBrowserConfig = new ImageBrowserConfig();
    }

    public static MNImageBrowser with(Context context) {
        return new MNImageBrowser(context);
    }

    public MNImageBrowser setImageUrl(String imageUrl) {
        ArrayList<String> imageList = new ArrayList<String>();
        imageList.add(imageUrl);
        this.imageBrowserConfig.setImageList(imageList);
        return this;
    }

    public MNImageBrowser setImageList(ArrayList<String> imageList) {
        ArrayList<String> newImageList = new ArrayList<String>();
        newImageList.addAll(imageList);
        this.imageBrowserConfig.setImageList(newImageList);
        return this;
    }

    public MNImageBrowser setCurrentPosition(int position) {
        this.imageBrowserConfig.setPosition(position);
        return this;
    }

    public MNImageBrowser setTransformType(ImageBrowserConfig.TransformType transformType) {
        this.imageBrowserConfig.setTransformType(transformType);
        return this;
    }

    public MNImageBrowser setImageEngine(ImageEngine imageEngine) {
        this.imageBrowserConfig.setImageEngine(imageEngine);
        return this;
    }

    public MNImageBrowser setOnClickListener(OnClickListener onClickListener) {
        this.imageBrowserConfig.setOnClickListener(onClickListener);
        return this;
    }

    public MNImageBrowser setOnLongClickListener(OnLongClickListener onLongClickListener) {
        this.imageBrowserConfig.setOnLongClickListener(onLongClickListener);
        return this;
    }

    public MNImageBrowser setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.imageBrowserConfig.setOnPageChangeListener(onPageChangeListener);
        return this;
    }

    public MNImageBrowser setIndicatorType(ImageBrowserConfig.IndicatorType indicatorType) {
        this.imageBrowserConfig.setIndicatorType(indicatorType);
        return this;
    }

    public MNImageBrowser setIndicatorHide(boolean indicatorHide) {
        this.imageBrowserConfig.setIndicatorHide(indicatorHide);
        return this;
    }

    public MNImageBrowser setCustomShadeView(View customView) {
        this.imageBrowserConfig.setCustomShadeView(customView);
        return this;
    }

    public MNImageBrowser setCustomProgressViewLayoutID(@LayoutRes int customViewID) {
        this.imageBrowserConfig.setCustomProgressViewLayoutID(customViewID);
        return this;
    }

    public MNImageBrowser setScreenOrientationType(ImageBrowserConfig.ScreenOrientationType screenOrientationType) {
        this.imageBrowserConfig.setScreenOrientationType(screenOrientationType);
        return this;
    }

    public MNImageBrowser setFullScreenMode(boolean fullScreenMode) {
        this.imageBrowserConfig.setFullScreenMode(fullScreenMode);
        return this;
    }

    public MNImageBrowser setOpenPullDownGestureEffect(boolean openPullDownGestureEffect) {
        this.imageBrowserConfig.setOpenPullDownGestureEffect(openPullDownGestureEffect);
        return this;
    }

    public MNImageBrowser setActivityOpenAnime(@AnimRes int activityOpenAnime) {
        this.imageBrowserConfig.setActivityOpenAnime(activityOpenAnime);
        return this;
    }

    public MNImageBrowser setActivityExitAnime(@AnimRes int activityExitAnime) {
        this.imageBrowserConfig.setActivityExitAnime(activityExitAnime);
        return this;
    }

    public void show(View view) {
        if (FastClickUtils.isFastClick()) {
            return;
        }
        if (this.imageBrowserConfig == null) {
            this.imageBrowserConfig = new ImageBrowserConfig();
        }
        if (this.imageBrowserConfig.getImageList() == null || this.imageBrowserConfig.getImageList().size() <= 0) {
            return;
        }
        if (this.imageBrowserConfig.getImageEngine() == null) {
            return;
        }
        if (this.imageBrowserConfig.getIndicatorType() == null) {
            this.imageBrowserConfig.setIndicatorType(ImageBrowserConfig.IndicatorType.Indicator_Number);
        }
        MNImageBrowserActivity.imageBrowserConfig = this.imageBrowserConfig;
        Intent intent = new Intent(this.context, MNImageBrowserActivity.class);
        this.startBrowserAvtivity(this.context, view, intent);
    }

    private void startBrowserAvtivity(Context context, View view, Intent intent) {
        if (this.imageBrowserConfig.getActivityOpenAnime() != R.anim.mn_browser_enter_anim) {
            context.startActivity(intent);
            ((Activity)context).overridePendingTransition(this.imageBrowserConfig.getActivityOpenAnime(), 0);
        } else {
            ActivityOptionsCompat optionsCompat = ActivityOptionsCompat.makeScaleUpAnimation((View)view, (int)(view.getWidth() / 2), (int)(view.getHeight() / 2), (int)0, (int)0);
            try {
                ActivityCompat.startActivity((Context)context, (Intent)intent, (Bundle)optionsCompat.toBundle());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                context.startActivity(intent);
                ((Activity)context).overridePendingTransition(R.anim.mn_browser_enter_anim, 0);
            }
        }
    }

    public static FragmentActivity getCurrentActivity() {
        return MNImageBrowserActivity.getCurrentActivity();
    }

    public static void finishImageBrowser() {
        MNImageBrowserActivity.finishActivity();
    }

    public static ImageView getCurrentImageView() {
        return MNImageBrowserActivity.getCurrentImageView();
    }

    public static int getCurrentPosition() {
        return MNImageBrowserActivity.getCurrentPosition();
    }

    public static ViewPager getViewPager() {
        return MNImageBrowserActivity.getViewPager();
    }

    public static void removeImage(int position) {
        MNImageBrowserActivity.removeImage(position);
    }

    public static void removeCurrentImage() {
        MNImageBrowserActivity.removeCurrentImage();
    }

    public static ArrayList<String> getImageList() {
        return MNImageBrowserActivity.getImageList();
    }
}

