/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.animation.TimeInterpolator;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.mancj.slideup.Internal;
import com.mancj.slideup.R;
import com.mancj.slideup.SlideUp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SlideUpBuilder {
    private boolean mStateRestored = false;
    View mSliderView;
    float mDensity;
    float mTouchableArea;
    boolean mIsRTL;
    SlideUp.State mStartState = SlideUp.State.HIDDEN;
    List<SlideUp.Listener> mListeners = new ArrayList<SlideUp.Listener>();
    boolean mDebug = false;
    int mAutoSlideDuration = 300;
    int mStartGravity = 80;
    boolean mGesturesEnabled = true;
    boolean mHideKeyboard = false;
    TimeInterpolator mInterpolator = new DecelerateInterpolator();
    View mAlsoScrollView;

    public SlideUpBuilder(View sliderView) {
        Internal.checkNonNull(sliderView, "View can't be null");
        this.mSliderView = sliderView;
        this.mDensity = sliderView.getResources().getDisplayMetrics().density;
        this.mIsRTL = sliderView.getResources().getBoolean(R.bool.is_right_to_left);
    }

    public SlideUpBuilder withStartState(@NonNull SlideUp.State startState) {
        if (!this.mStateRestored) {
            this.mStartState = startState;
        }
        return this;
    }

    public SlideUpBuilder withStartGravity(int gravity) {
        if (!this.mStateRestored) {
            this.mStartGravity = gravity;
        }
        return this;
    }

    public SlideUpBuilder withListeners(@NonNull List<SlideUp.Listener> listeners) {
        if (listeners != null) {
            this.mListeners.addAll(listeners);
        }
        return this;
    }

    public SlideUpBuilder withListeners(SlideUp.Listener ... listeners) {
        ArrayList<SlideUp.Listener> listeners_list = new ArrayList<SlideUp.Listener>();
        Collections.addAll(listeners_list, listeners);
        return this.withListeners(listeners_list);
    }

    public SlideUpBuilder withLoggingEnabled(boolean enabled) {
        if (!this.mStateRestored) {
            this.mDebug = enabled;
        }
        return this;
    }

    public SlideUpBuilder withAutoSlideDuration(int duration) {
        if (!this.mStateRestored) {
            this.mAutoSlideDuration = duration;
        }
        return this;
    }

    public SlideUpBuilder withTouchableAreaPx(float area) {
        if (!this.mStateRestored) {
            this.mTouchableArea = area;
        }
        return this;
    }

    public SlideUpBuilder withTouchableAreaDp(float area) {
        if (!this.mStateRestored) {
            this.mTouchableArea = area * this.mDensity;
        }
        return this;
    }

    public SlideUpBuilder withGesturesEnabled(boolean enabled) {
        this.mGesturesEnabled = enabled;
        return this;
    }

    public SlideUpBuilder withHideSoftInputWhenDisplayed(boolean hide) {
        if (!this.mStateRestored) {
            this.mHideKeyboard = hide;
        }
        return this;
    }

    public SlideUpBuilder withInterpolator(TimeInterpolator interpolator) {
        this.mInterpolator = interpolator;
        return this;
    }

    public SlideUpBuilder withSavedState(@Nullable Bundle savedState) {
        this.restoreParams(savedState);
        return this;
    }

    public SlideUpBuilder withSlideFromOtherView(@Nullable View alsoScrollView) {
        this.mAlsoScrollView = alsoScrollView;
        return this;
    }

    public SlideUp build() {
        return new SlideUp(this);
    }

    private void restoreParams(@Nullable Bundle savedState) {
        if (savedState == null) {
            return;
        }
        this.mStateRestored = savedState.getBoolean(SlideUp.KEY_STATE_SAVED, false);
        if (savedState.getSerializable(SlideUp.KEY_STATE) != null) {
            this.mStartState = (SlideUp.State)((Object)savedState.getSerializable(SlideUp.KEY_STATE));
        }
        this.mStartGravity = savedState.getInt(SlideUp.KEY_START_GRAVITY, this.mStartGravity);
        this.mDebug = savedState.getBoolean(SlideUp.KEY_DEBUG, this.mDebug);
        this.mTouchableArea = savedState.getFloat(SlideUp.KEY_TOUCHABLE_AREA, this.mTouchableArea) * this.mDensity;
        this.mAutoSlideDuration = savedState.getInt(SlideUp.KEY_AUTO_SLIDE_DURATION, this.mAutoSlideDuration);
        this.mHideKeyboard = savedState.getBoolean(SlideUp.KEY_HIDE_SOFT_INPUT, this.mHideKeyboard);
    }
}

