/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import com.mancj.slideup.AnimationProcessor;
import com.mancj.slideup.HorizontalTouchConsumer;
import com.mancj.slideup.LoggerNotifier;
import com.mancj.slideup.OnGlobalLayoutSingleListener;
import com.mancj.slideup.SlideUpBuilder;
import com.mancj.slideup.VerticalTouchConsumer;
import java.io.Serializable;

public class SlideUp
implements View.OnTouchListener,
ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener,
LoggerNotifier {
    private static final String TAG = SlideUp.class.getSimpleName();
    static final String KEY_START_GRAVITY = TAG + "_start_gravity";
    static final String KEY_DEBUG = TAG + "_debug";
    static final String KEY_TOUCHABLE_AREA = TAG + "_touchable_area";
    static final String KEY_STATE = TAG + "_state";
    static final String KEY_AUTO_SLIDE_DURATION = TAG + "_auto_slide_duration";
    static final String KEY_HIDE_SOFT_INPUT = TAG + "_hide_soft_input";
    static final String KEY_STATE_SAVED = TAG + "_state_saved";
    private State mCurrentState;
    private float mViewHeight;
    private float mViewWidth;
    private SlideUpBuilder mBuilder;
    private VerticalTouchConsumer mVerticalTouchConsumer;
    private HorizontalTouchConsumer mHorizontalTouchConsumer;
    private AnimationProcessor mAnimationProcessor;

    SlideUp(SlideUpBuilder builder) {
        this.mBuilder = builder;
        this.init();
    }

    private void init() {
        this.mBuilder.mSliderView.setOnTouchListener((View.OnTouchListener)this);
        if (this.mBuilder.mAlsoScrollView != null) {
            this.mBuilder.mAlsoScrollView.setOnTouchListener((View.OnTouchListener)this);
        }
        this.createAnimation();
        this.mBuilder.mSliderView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)new OnGlobalLayoutSingleListener(this.mBuilder.mSliderView, new Runnable(){

            @Override
            public void run() {
                SlideUp.this.mViewHeight = ((SlideUp)SlideUp.this).mBuilder.mSliderView.getHeight();
                SlideUp.this.mViewWidth = ((SlideUp)SlideUp.this).mBuilder.mSliderView.getWidth();
                switch (((SlideUp)SlideUp.this).mBuilder.mStartGravity) {
                    case 48: {
                        ((SlideUp)SlideUp.this).mBuilder.mSliderView.setPivotY(SlideUp.this.mViewHeight);
                        SlideUp.this.setTouchableAreaVertical();
                        break;
                    }
                    case 80: {
                        ((SlideUp)SlideUp.this).mBuilder.mSliderView.setPivotY(0.0f);
                        SlideUp.this.setTouchableAreaVertical();
                        break;
                    }
                    case 0x800003: {
                        ((SlideUp)SlideUp.this).mBuilder.mSliderView.setPivotX(0.0f);
                        SlideUp.this.setTouchableAreaHorizontal();
                        break;
                    }
                    case 0x800005: {
                        ((SlideUp)SlideUp.this).mBuilder.mSliderView.setPivotX(SlideUp.this.mViewWidth);
                        SlideUp.this.setTouchableAreaHorizontal();
                    }
                }
                SlideUp.this.createConsumers();
                SlideUp.this.updateToCurrentState();
            }
        }));
        this.updateToCurrentState();
    }

    private void setTouchableAreaHorizontal() {
        if (this.mBuilder.mTouchableArea == 0.0f) {
            this.mBuilder.mTouchableArea = (float)Math.ceil(this.mViewWidth / 10.0f);
        }
    }

    private void setTouchableAreaVertical() {
        if (this.mBuilder.mTouchableArea == 0.0f) {
            this.mBuilder.mTouchableArea = (float)Math.ceil(this.mViewHeight / 10.0f);
        }
    }

    private void createAnimation() {
        this.mAnimationProcessor = new AnimationProcessor(this.mBuilder, this, this);
    }

    private void createConsumers() {
        this.createAnimation();
        this.mVerticalTouchConsumer = new VerticalTouchConsumer(this.mBuilder, this, this.mAnimationProcessor);
        this.mHorizontalTouchConsumer = new HorizontalTouchConsumer(this.mBuilder, this, this.mAnimationProcessor);
    }

    private void updateToCurrentState() {
        switch (this.mBuilder.mStartState) {
            case HIDDEN: {
                this.hideImmediately();
                break;
            }
            case SHOWED: {
                this.showImmediately();
            }
        }
    }

    public void hideSoftInput() {
        ((InputMethodManager)this.mBuilder.mSliderView.getContext().getSystemService("input_method")).hideSoftInputFromWindow(this.mBuilder.mSliderView.getWindowToken(), 2);
    }

    public void showSoftInput() {
        ((InputMethodManager)this.mBuilder.mSliderView.getContext().getSystemService("input_method")).showSoftInput(this.mBuilder.mSliderView, 0);
    }

    public boolean isVisible() {
        return this.mBuilder.mSliderView.getVisibility() == 0;
    }

    public void addSlideListener(@NonNull Listener listener) {
        this.mBuilder.mListeners.add(listener);
    }

    public void removeSlideListener(@NonNull Listener listener) {
        this.mBuilder.mListeners.remove(listener);
    }

    public <T extends View> T getSliderView() {
        return (T)this.mBuilder.mSliderView;
    }

    public void setAutoSlideDuration(int autoSlideDuration) {
        this.mBuilder.withAutoSlideDuration(autoSlideDuration);
        this.mAnimationProcessor.paramsChanged();
    }

    public float getAutoSlideDuration() {
        return this.mBuilder.mAutoSlideDuration;
    }

    public void setTouchableAreaDp(float touchableArea) {
        this.mBuilder.withTouchableAreaDp(touchableArea);
    }

    public void setTouchableAreaPx(float touchableArea) {
        this.mBuilder.withTouchableAreaPx(touchableArea);
    }

    public float getTouchableAreaDp() {
        return this.mBuilder.mTouchableArea / this.mBuilder.mDensity;
    }

    public float getTouchableAreaPx() {
        return this.mBuilder.mTouchableArea;
    }

    public boolean isAnimationRunning() {
        return this.mAnimationProcessor.isAnimationRunning();
    }

    public void show() {
        this.show(false);
    }

    public void hide() {
        this.hide(false);
    }

    public void hideImmediately() {
        this.hide(true);
    }

    public void showImmediately() {
        this.show(true);
    }

    public void setLoggingEnabled(boolean enabled) {
        this.mBuilder.withLoggingEnabled(enabled);
    }

    public boolean isLoggingEnabled() {
        return this.mBuilder.mDebug;
    }

    public void setGesturesEnabled(boolean enabled) {
        this.mBuilder.withGesturesEnabled(enabled);
    }

    public boolean isGesturesEnabled() {
        return this.mBuilder.mGesturesEnabled;
    }

    public TimeInterpolator getInterpolator() {
        return this.mBuilder.mInterpolator;
    }

    public int getStartGravity() {
        return this.mBuilder.mStartGravity;
    }

    public void setInterpolator(TimeInterpolator interpolator) {
        this.mBuilder.withInterpolator(interpolator);
        this.mAnimationProcessor.paramsChanged();
    }

    public boolean isHideKeyboardWhenDisplayed() {
        return this.mBuilder.mHideKeyboard;
    }

    public void setHideKeyboardWhenDisplayed(boolean hide) {
        this.mBuilder.withHideSoftInputWhenDisplayed(hide);
    }

    public void toggle() {
        if (this.isVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    public void toggleImmediately() {
        if (this.isVisible()) {
            this.hideImmediately();
        } else {
            this.showImmediately();
        }
    }

    public void onSaveInstanceState(@NonNull Bundle savedState) {
        savedState.putBoolean(KEY_STATE_SAVED, true);
        savedState.putInt(KEY_START_GRAVITY, this.mBuilder.mStartGravity);
        savedState.putBoolean(KEY_DEBUG, this.mBuilder.mDebug);
        savedState.putFloat(KEY_TOUCHABLE_AREA, this.mBuilder.mTouchableArea / this.mBuilder.mDensity);
        savedState.putSerializable(KEY_STATE, (Serializable)((Object)this.mCurrentState));
        savedState.putInt(KEY_AUTO_SLIDE_DURATION, this.mBuilder.mAutoSlideDuration);
        savedState.putBoolean(KEY_HIDE_SOFT_INPUT, this.mBuilder.mHideKeyboard);
    }

    private void hide(boolean immediately) {
        this.mAnimationProcessor.endAnimation();
        switch (this.mBuilder.mStartGravity) {
            case 48: {
                if (immediately) {
                    if (this.mBuilder.mSliderView.getHeight() > 0) {
                        this.mBuilder.mSliderView.setTranslationY(-this.mViewHeight);
                        this.notifyPercentChanged(100.0f);
                        break;
                    }
                    this.mBuilder.mStartState = State.HIDDEN;
                    break;
                }
                this.mAnimationProcessor.setValuesAndStart(this.mBuilder.mSliderView.getTranslationY(), this.mBuilder.mSliderView.getHeight());
                break;
            }
            case 80: {
                if (immediately) {
                    if (this.mBuilder.mSliderView.getHeight() > 0) {
                        this.mBuilder.mSliderView.setTranslationY(this.mViewHeight);
                        this.notifyPercentChanged(100.0f);
                        break;
                    }
                    this.mBuilder.mStartState = State.HIDDEN;
                    break;
                }
                this.mAnimationProcessor.setValuesAndStart(this.mBuilder.mSliderView.getTranslationY(), this.mBuilder.mSliderView.getHeight());
                break;
            }
            case 0x800003: {
                if (immediately) {
                    if (this.mBuilder.mSliderView.getWidth() > 0) {
                        this.mBuilder.mSliderView.setTranslationX(-this.mViewWidth);
                        this.notifyPercentChanged(100.0f);
                        break;
                    }
                    this.mBuilder.mStartState = State.HIDDEN;
                    break;
                }
                this.mAnimationProcessor.setValuesAndStart(this.mBuilder.mSliderView.getTranslationX(), this.mBuilder.mSliderView.getHeight());
                break;
            }
            case 0x800005: {
                if (immediately) {
                    if (this.mBuilder.mSliderView.getWidth() > 0) {
                        this.mBuilder.mSliderView.setTranslationX(this.mViewWidth);
                        this.notifyPercentChanged(100.0f);
                        break;
                    }
                    this.mBuilder.mStartState = State.HIDDEN;
                    break;
                }
                this.mAnimationProcessor.setValuesAndStart(this.mBuilder.mSliderView.getTranslationX(), this.mBuilder.mSliderView.getHeight());
            }
        }
    }

    private void show(boolean immediately) {
        this.mAnimationProcessor.endAnimation();
        switch (this.mBuilder.mStartGravity) {
            case 48: {
                if (immediately) {
                    if (this.mBuilder.mSliderView.getHeight() > 0) {
                        this.mBuilder.mSliderView.setTranslationY(0.0f);
                        this.notifyPercentChanged(0.0f);
                    } else {
                        this.mBuilder.mStartState = State.SHOWED;
                    }
                } else {
                    this.mAnimationProcessor.setValuesAndStart(this.mBuilder.mSliderView.getTranslationY(), 0.0f);
                }
            }
            case 80: {
                if (immediately) {
                    if (this.mBuilder.mSliderView.getHeight() > 0) {
                        this.mBuilder.mSliderView.setTranslationY(0.0f);
                        this.notifyPercentChanged(0.0f);
                        break;
                    }
                    this.mBuilder.mStartState = State.SHOWED;
                    break;
                }
                this.mAnimationProcessor.setValuesAndStart(this.mBuilder.mSliderView.getTranslationY(), 0.0f);
                break;
            }
            case 0x800003: {
                if (immediately) {
                    if (this.mBuilder.mSliderView.getWidth() > 0) {
                        this.mBuilder.mSliderView.setTranslationX(0.0f);
                        this.notifyPercentChanged(0.0f);
                    } else {
                        this.mBuilder.mStartState = State.SHOWED;
                    }
                } else {
                    this.mAnimationProcessor.setValuesAndStart(this.mBuilder.mSliderView.getTranslationX(), 0.0f);
                }
            }
            case 0x800005: {
                if (immediately) {
                    if (this.mBuilder.mSliderView.getWidth() > 0) {
                        this.mBuilder.mSliderView.setTranslationX(0.0f);
                        this.notifyPercentChanged(0.0f);
                        break;
                    }
                    this.mBuilder.mStartState = State.SHOWED;
                    break;
                }
                this.mAnimationProcessor.setValuesAndStart(this.mBuilder.mSliderView.getTranslationX(), 0.0f);
            }
        }
    }

    public final boolean onTouch(View v, MotionEvent event) {
        boolean consumed;
        if (this.mAnimationProcessor.isAnimationRunning()) {
            return false;
        }
        if (!this.mBuilder.mGesturesEnabled) {
            this.mBuilder.mSliderView.performClick();
            return true;
        }
        switch (this.mBuilder.mStartGravity) {
            case 48: {
                consumed = this.mVerticalTouchConsumer.consumeTopToBottom(v, event);
                break;
            }
            case 80: {
                consumed = this.mVerticalTouchConsumer.consumeBottomToTop(v, event);
                break;
            }
            case 0x800003: {
                consumed = this.mHorizontalTouchConsumer.consumeStartToEnd(v, event);
                break;
            }
            case 0x800005: {
                consumed = this.mHorizontalTouchConsumer.consumeEndToStart(v, event);
                break;
            }
            default: {
                throw new IllegalArgumentException("You are using not supported gravity");
            }
        }
        if (!consumed) {
            this.mBuilder.mSliderView.performClick();
        }
        return true;
    }

    public final void onAnimationUpdate(ValueAnimator animation) {
        float value = ((Float)animation.getAnimatedValue()).floatValue();
        switch (this.mBuilder.mStartGravity) {
            case 48: {
                this.onAnimationUpdateTopToBottom(value);
                break;
            }
            case 80: {
                this.onAnimationUpdateBottomToTop(value);
                break;
            }
            case 0x800003: {
                this.onAnimationUpdateStartToEnd(value);
                break;
            }
            case 0x800005: {
                this.onAnimationUpdateEndToStart(value);
            }
        }
    }

    private void onAnimationUpdateTopToBottom(float value) {
        this.mBuilder.mSliderView.setTranslationY(-value);
        float visibleDistance = (float)this.mBuilder.mSliderView.getTop() - this.mBuilder.mSliderView.getY();
        float percents = visibleDistance * 100.0f / this.mViewHeight;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateBottomToTop(float value) {
        this.mBuilder.mSliderView.setTranslationY(value);
        float visibleDistance = this.mBuilder.mSliderView.getY() - (float)this.mBuilder.mSliderView.getTop();
        float percents = visibleDistance * 100.0f / this.mViewHeight;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateStartToEnd(float value) {
        this.mBuilder.mSliderView.setTranslationX(-value);
        float visibleDistance = this.mBuilder.mSliderView.getX() - (float)this.getStart();
        float percents = visibleDistance * 100.0f / -this.mViewWidth;
        this.notifyPercentChanged(percents);
    }

    private void onAnimationUpdateEndToStart(float value) {
        this.mBuilder.mSliderView.setTranslationX(value);
        float visibleDistance = this.mBuilder.mSliderView.getX() - (float)this.getStart();
        float percents = visibleDistance * 100.0f / this.mViewWidth;
        this.notifyPercentChanged(percents);
    }

    private int getStart() {
        if (this.mBuilder.mIsRTL) {
            return this.mBuilder.mSliderView.getRight();
        }
        return this.mBuilder.mSliderView.getLeft();
    }

    @Override
    public void notifyPercentChanged(float percent) {
        percent = percent > 100.0f ? 100.0f : percent;
        float f = percent = percent < 0.0f ? 0.0f : percent;
        if (percent == 100.0f) {
            this.mBuilder.mSliderView.setVisibility(8);
            this.notifyVisibilityChanged(8);
        } else {
            this.mBuilder.mSliderView.setVisibility(0);
            if (percent == 0.0f) {
                this.notifyVisibilityChanged(0);
            }
        }
        if (this.mAnimationProcessor.getSlideAnimationTo() == 0.0f && this.mBuilder.mHideKeyboard) {
            this.hideSoftInput();
        }
        if (!this.mBuilder.mListeners.isEmpty()) {
            for (int i = 0; i < this.mBuilder.mListeners.size(); ++i) {
                Listener l = this.mBuilder.mListeners.get(i);
                if (l != null) {
                    if (!(l instanceof Listener.Slide)) continue;
                    Listener.Slide slide = (Listener.Slide)l;
                    slide.onSlide(percent);
                    this.logValue(i, "onSlide", Float.valueOf(percent));
                    continue;
                }
                this.logError(i, "onSlide");
            }
        }
    }

    @Override
    public void notifyVisibilityChanged(int visibility) {
        if (!this.mBuilder.mListeners.isEmpty()) {
            for (int i = 0; i < this.mBuilder.mListeners.size(); ++i) {
                Listener l = this.mBuilder.mListeners.get(i);
                if (l != null) {
                    if (!(l instanceof Listener.Visibility)) continue;
                    Listener.Visibility vis = (Listener.Visibility)l;
                    vis.onVisibilityChanged(visibility);
                    this.logValue(i, "onVisibilityChanged", visibility == 0 ? "VISIBLE" : (visibility == 8 ? "GONE" : Integer.valueOf(visibility)));
                    continue;
                }
                this.logError(i, "onVisibilityChanged");
            }
        }
        switch (visibility) {
            case 0: {
                this.mCurrentState = State.SHOWED;
                break;
            }
            case 8: {
                this.mCurrentState = State.HIDDEN;
            }
        }
    }

    public final void onAnimationStart(Animator animator) {
    }

    public final void onAnimationEnd(Animator animator) {
    }

    public final void onAnimationCancel(Animator animator) {
    }

    public final void onAnimationRepeat(Animator animator) {
    }

    private void logValue(int listener, String method, Object message) {
        if (this.mBuilder.mDebug) {
            Log.e((String)TAG, (String)String.format("Listener(%1s) (%2$-23s) value = %3$s", listener, method, message));
        }
    }

    private void logError(int listener, String method) {
        if (this.mBuilder.mDebug) {
            Log.d((String)TAG, (String)String.format("Listener(%1s) (%2$-23s) Listener is null, skip notification...", listener, method));
        }
    }

    public static interface Listener {

        public static interface Events
        extends Visibility,
        Slide {
        }

        public static interface Visibility
        extends Listener {
            public void onVisibilityChanged(int var1);
        }

        public static interface Slide
        extends Listener {
            public void onSlide(float var1);
        }
    }

    public static enum State {
        HIDDEN,
        SHOWED;

    }
}

