/*
 * Decompiled with CFR 0.152.
 */
package com.mancj.slideup;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.DecelerateInterpolator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SlideUp<T extends View>
implements View.OnTouchListener,
ValueAnimator.AnimatorUpdateListener,
Animator.AnimatorListener {
    private static final String TAG = "SlideUp";
    private static final String KEY_DIRECTION = "SlideUp_direction";
    private static final String KEY_DEBUG = "SlideUp_debug";
    private static final String KEY_TOUCHABLE_AREA = "SlideUp_touchable_area";
    private static final String KEY_STATE = "SlideUp_state";
    private static final String KEY_AUTO_SLIDE_DURATION = "SlideUp_auto_slide_duration";
    private State startState;
    private State currentState;
    private T sliderView;
    private float touchableArea;
    private int autoSlideDuration;
    private List<Listener> listeners;
    private ValueAnimator valueAnimator;
    private float slideAnimationTo;
    private float startPositionY;
    private float viewStartPositionY;
    private boolean canSlide = true;
    private float density;
    private float maxSlidePosition;
    private float viewHeight;
    private boolean downToUp = true;
    private boolean debug = false;

    private SlideUp(Builder<T> builder) {
        this.downToUp = ((Builder)builder).vectorDownToUp;
        this.listeners = ((Builder)builder).listeners;
        this.sliderView = ((Builder)builder).sliderView;
        this.startState = ((Builder)builder).startState;
        this.density = ((Builder)builder).density;
        this.touchableArea = ((Builder)builder).touchableArea;
        this.autoSlideDuration = ((Builder)builder).autoSlideDuration;
        this.debug = ((Builder)builder).debug;
        this.init();
    }

    private void init() {
        this.sliderView.setOnTouchListener((View.OnTouchListener)this);
        this.createAnimation();
        this.sliderView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                SlideUp.this.viewHeight = SlideUp.this.sliderView.getHeight();
                SlideUp.this.sliderView.setPivotY(SlideUp.this.downToUp ? 0.0f : SlideUp.this.viewHeight);
                SlideUp.this.updateToCurrentState();
                ViewTreeObserver observer = SlideUp.this.sliderView.getViewTreeObserver();
                if (Build.VERSION.SDK_INT <= 16) {
                    observer.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                } else {
                    observer.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
            }
        });
        this.updateToCurrentState();
    }

    private void updateToCurrentState() {
        switch (this.startState) {
            case HIDDEN: {
                this.hideImmediately();
                break;
            }
            case SHOWED: {
                this.showImmediately();
            }
        }
    }

    public void setDownToUp() {
        this.downToUp = true;
    }

    public void setUpToDown() {
        this.downToUp = false;
    }

    public boolean isVisible() {
        return this.sliderView.getVisibility() == 0;
    }

    @Deprecated
    public void setSlideListener(@NonNull Listener listener) {
        this.listeners.add(listener);
    }

    public void addSlideListener(@NonNull Listener listener) {
        this.listeners.add(listener);
    }

    public void removeSlideListener(@NonNull Listener listener) {
        this.listeners.remove(listener);
    }

    public T getSliderView() {
        return this.sliderView;
    }

    public void setAutoSlideDuration(int autoSlideDuration) {
        this.autoSlideDuration = autoSlideDuration;
    }

    public float getAutoSlideDuration() {
        return this.autoSlideDuration;
    }

    public void setTouchableArea(float touchableArea) {
        this.touchableArea = touchableArea * this.density;
    }

    public float getTouchableArea() {
        return this.touchableArea / this.density;
    }

    public boolean isAnimationRunning() {
        return this.valueAnimator != null && this.valueAnimator.isRunning();
    }

    public void show() {
        this.slideAnimationTo = 0.0f;
        this.valueAnimator.setFloatValues(new float[]{this.viewHeight, this.slideAnimationTo});
        this.valueAnimator.start();
    }

    public void hide() {
        this.slideAnimationTo = this.downToUp ? (float)this.sliderView.getHeight() : (float)(-this.sliderView.getHeight());
        this.valueAnimator.setFloatValues(new float[]{this.sliderView.getTranslationY(), this.slideAnimationTo});
        this.valueAnimator.start();
    }

    public void hideImmediately() {
        if (this.sliderView.getHeight() > 0) {
            this.sliderView.setTranslationY(this.downToUp ? this.viewHeight : -this.viewHeight);
            this.sliderView.setVisibility(8);
            this.notifyVisibilityChanged(8);
        } else {
            this.startState = State.HIDDEN;
        }
    }

    public void showImmediately() {
        if (this.sliderView.getHeight() > 0) {
            this.sliderView.setTranslationY(0.0f);
            this.sliderView.setVisibility(0);
            this.notifyVisibilityChanged(0);
        } else {
            this.startState = State.SHOWED;
        }
    }

    private void createAnimation() {
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[0]);
        this.valueAnimator.setDuration((long)this.autoSlideDuration);
        this.valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        this.valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
        this.valueAnimator.addListener((Animator.AnimatorListener)this);
    }

    public Bundle onSaveInstanceState(@Nullable Bundle savedState) {
        if (savedState == null) {
            savedState = Bundle.EMPTY;
        }
        savedState.putBoolean(KEY_DIRECTION, this.downToUp);
        savedState.putBoolean(KEY_DEBUG, this.debug);
        savedState.putFloat(KEY_TOUCHABLE_AREA, this.touchableArea / this.density);
        savedState.putParcelable(KEY_STATE, (Parcelable)this.currentState);
        savedState.putInt(KEY_AUTO_SLIDE_DURATION, this.autoSlideDuration);
        return savedState;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.downToUp) {
            return this.onTouchDownToUp(event);
        }
        return this.onTouchUpToDown(event);
    }

    private boolean onTouchDownToUp(MotionEvent event) {
        float touchedArea = event.getRawY() - (float)this.sliderView.getTop();
        if (this.isAnimationRunning()) {
            return false;
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.viewHeight = this.sliderView.getHeight();
                this.startPositionY = event.getRawY();
                this.viewStartPositionY = this.sliderView.getTranslationY();
                if (!(this.touchableArea < touchedArea)) break;
                this.canSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.startPositionY;
                float moveTo = this.viewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)this.sliderView.getHeight();
                if (moveTo > 0.0f && this.canSlide) {
                    this.notifyPercentChanged(percents);
                    this.sliderView.setTranslationY(moveTo);
                }
                if (!(event.getRawY() > this.maxSlidePosition)) break;
                this.maxSlidePosition = event.getRawY();
                break;
            }
            case 1: {
                float slideAnimationFrom = this.sliderView.getTranslationY();
                boolean mustShow = this.maxSlidePosition > event.getRawY();
                boolean scrollableAreaConsumed = this.sliderView.getTranslationY() > (float)(this.sliderView.getHeight() / 5);
                this.slideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)this.sliderView.getHeight() : 0.0f;
                this.valueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.slideAnimationTo});
                this.valueAnimator.start();
                this.canSlide = true;
                this.maxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    private boolean onTouchUpToDown(MotionEvent event) {
        float touchedArea = (float)this.sliderView.getBottom() - event.getRawY();
        if (this.isAnimationRunning()) {
            return false;
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.viewHeight = this.sliderView.getHeight();
                this.startPositionY = event.getRawY();
                this.viewStartPositionY = this.sliderView.getTranslationY();
                this.maxSlidePosition = this.viewHeight;
                if (!(this.touchableArea < touchedArea)) break;
                this.canSlide = false;
                break;
            }
            case 2: {
                float difference = event.getRawY() - this.startPositionY;
                float moveTo = this.viewStartPositionY + difference;
                float percents = moveTo * 100.0f / (float)(-this.sliderView.getHeight());
                if (moveTo < 0.0f && this.canSlide) {
                    this.notifyPercentChanged(percents);
                    this.sliderView.setTranslationY(moveTo);
                }
                if (!(event.getRawY() < this.maxSlidePosition)) break;
                this.maxSlidePosition = event.getRawY();
                break;
            }
            case 1: {
                float slideAnimationFrom = -this.sliderView.getTranslationY();
                boolean mustShow = this.maxSlidePosition < event.getRawY();
                boolean scrollableAreaConsumed = this.sliderView.getTranslationY() < (float)(-this.sliderView.getHeight() / 5);
                this.slideAnimationTo = scrollableAreaConsumed && !mustShow ? (float)(this.sliderView.getHeight() + this.sliderView.getTop()) : 0.0f;
                this.valueAnimator.setFloatValues(new float[]{slideAnimationFrom, this.slideAnimationTo});
                this.valueAnimator.start();
                this.canSlide = true;
                this.maxSlidePosition = 0.0f;
            }
        }
        return true;
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        float val = ((Float)animation.getAnimatedValue()).floatValue();
        this.sliderView.setTranslationY(this.downToUp ? val : -val);
        float total = this.downToUp ? this.viewHeight : -this.viewHeight;
        float percents = (this.sliderView.getY() - (float)this.sliderView.getTop()) * 100.0f / total;
        this.notifyPercentChanged(percents);
    }

    private void notifyPercentChanged(float percent) {
        percent = percent > 100.0f ? 100.0f : percent;
        float f = percent = percent < 0.0f ? 0.0f : percent;
        if (!this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener l = this.listeners.get(i);
                if (l != null) {
                    l.onSlide(percent);
                    this.d("Listener(" + i + ")", "(onSlide)", "value = " + percent);
                    continue;
                }
                this.e("Listener(" + i + ")", "(onSlide)", "Listener is null, skip notify for him...");
            }
        }
    }

    private void notifyVisibilityChanged(int visibility) {
        if (!this.listeners.isEmpty()) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                Listener l = this.listeners.get(i);
                if (l != null) {
                    l.onVisibilityChanged(visibility);
                    this.d("Listener(" + i + ")", "(onVisibilityChanged)", "value = " + (visibility == 0 ? "VISIBLE" : (visibility == 8 ? "GONE" : Integer.valueOf(visibility))));
                    continue;
                }
                this.e("Listener(" + i + ")", "(onVisibilityChanged)", "Listener is null, skip  notify for him...");
            }
        }
        switch (visibility) {
            case 0: {
                this.currentState = State.SHOWED;
            }
            case 8: {
                this.currentState = State.HIDDEN;
            }
        }
    }

    public void onAnimationStart(Animator animator) {
        this.sliderView.setVisibility(0);
        this.notifyVisibilityChanged(0);
    }

    public void onAnimationEnd(Animator animator) {
        if (this.slideAnimationTo != 0.0f) {
            this.sliderView.setVisibility(8);
            this.notifyVisibilityChanged(8);
        }
    }

    public void onAnimationCancel(Animator animator) {
    }

    public void onAnimationRepeat(Animator animator) {
    }

    private void e(String listener, String method, String message) {
        if (this.debug) {
            Log.e((String)TAG, (String)String.format("%1$-15s %2$-23s %3$s", listener, method, message));
        }
    }

    private void d(String listener, String method, String value) {
        if (this.debug) {
            Log.d((String)TAG, (String)String.format("%1$-15s %2$-23s %3$s", listener, method, value));
        }
    }

    public static enum State implements Parcelable
    {
        HIDDEN,
        SHOWED;

        public static final Parcelable.Creator<State> CREATOR;

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.ordinal());
        }

        public int describeContents() {
            return 0;
        }

        static {
            CREATOR = new Parcelable.Creator<State>(){

                public State createFromParcel(Parcel in) {
                    return State.values()[in.readInt()];
                }

                public State[] newArray(int size) {
                    return new State[size];
                }
            };
        }
    }

    public static class Builder<T extends View> {
        private T sliderView;
        private State startState = State.HIDDEN;
        private boolean vectorDownToUp = true;
        private List<Listener> listeners = new ArrayList<Listener>();
        private boolean debug = false;
        private float touchableArea;
        private int autoSlideDuration = 300;
        private float density;

        private Builder() {
        }

        public static Builder forView(@NonNull View sliderView) {
            Builder builder = new Builder();
            builder.sliderView = sliderView;
            builder.density = sliderView.getResources().getDisplayMetrics().density;
            builder.touchableArea = 300.0f * builder.density;
            return builder;
        }

        public Builder withStartState(@NonNull State startState) {
            this.startState = startState;
            return this;
        }

        public Builder withDownToUpVector(boolean downToUp) {
            this.vectorDownToUp = downToUp;
            return this;
        }

        public Builder withListeners(@NonNull List<Listener> listeners) {
            this.listeners = listeners;
            return this;
        }

        public Builder withListeners(Listener ... listeners) {
            ArrayList<Listener> listeners_list = new ArrayList<Listener>();
            Collections.addAll(listeners_list, listeners);
            return this.withListeners(listeners_list);
        }

        public Builder withLoggingEnabled(boolean enable) {
            this.debug = enable;
            return this;
        }

        public Builder withAutoSlideDuration(int duration) {
            this.autoSlideDuration = duration;
            return this;
        }

        public Builder withTouchableArea(float area) {
            this.touchableArea = area * this.density;
            return this;
        }

        public Builder withSavedState(@Nullable Bundle savedState) {
            this.restoreParams(savedState);
            return this;
        }

        public SlideUp<T> build() {
            return new SlideUp(this);
        }

        private void restoreParams(@Nullable Bundle savedState) {
            if (savedState == null) {
                return;
            }
            if (savedState.getParcelable(SlideUp.KEY_STATE) != null) {
                this.startState = (State)savedState.getParcelable(SlideUp.KEY_STATE);
            }
            this.vectorDownToUp = savedState.getBoolean(SlideUp.KEY_DIRECTION, this.vectorDownToUp);
            this.debug = savedState.getBoolean(SlideUp.KEY_DEBUG, this.debug);
            this.touchableArea = savedState.getFloat(SlideUp.KEY_TOUCHABLE_AREA, this.touchableArea) * this.density;
            this.autoSlideDuration = savedState.getInt(SlideUp.KEY_AUTO_SLIDE_DURATION, this.autoSlideDuration);
        }
    }

    public static class ListenerAdapter
    implements Listener {
        @Override
        public void onSlide(float percent) {
        }

        @Override
        public void onVisibilityChanged(int visibility) {
        }
    }

    public static interface Listener {
        public void onSlide(float var1);

        public void onVisibilityChanged(int var1);
    }
}

