/*
 * Decompiled with CFR 0.152.
 */
package com.maps.route;

import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolylineOptions;
import com.maps.route.DrawerApi;
import com.maps.route.model.GeoPoint;
import com.maps.route.model.Legs;
import com.maps.route.model.Route;
import com.maps.route.model.Routes;
import com.maps.route.model.Step;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/maps/route/RouteDrawer;", "Lcom/maps/route/DrawerApi;", "builder", "Lcom/maps/route/RouteDrawer$RouteDrawerBuilder;", "(Lcom/maps/route/RouteDrawer$RouteDrawerBuilder;)V", "alpha", "", "bitmapDescriptor", "Lcom/google/android/gms/maps/model/BitmapDescriptor;", "googleMap", "Lcom/google/android/gms/maps/GoogleMap;", "pathColor", "", "pathWidth", "drawPath", "", "routes", "Lcom/maps/route/model/Routes;", "Companion", "RouteDrawerBuilder", "drawroute_release"})
public final class RouteDrawer
implements DrawerApi {
    private final float alpha;
    private final int pathWidth;
    private final int pathColor;
    private final BitmapDescriptor bitmapDescriptor;
    private final GoogleMap googleMap;
    private static final float DEFAULT_MARKER_ALPHA = 1.0f;
    private static final int DEFAULT_PATH_WIDTH = 5;
    private static final int DEFAULT_PATH_COLOR = -65536;
    public static final Companion Companion = new Companion(null);

    @Override
    public void drawPath(@NotNull Routes routes) {
        Intrinsics.checkNotNullParameter((Object)routes, (String)"routes");
        PolylineOptions polylineOptions = null;
        List<Route> list = routes.getRoutes();
        Intrinsics.checkNotNull(list);
        for (Route route : list) {
            List<Legs> list2 = route.getLegs();
            Intrinsics.checkNotNull(list2);
            for (Legs legs : list2) {
                polylineOptions = new PolylineOptions();
                List<Step> list3 = legs.getSteps();
                Intrinsics.checkNotNull(list3);
                for (Step step : list3) {
                    GeoPoint geoPoint = step.getStartLocation();
                    Double d = geoPoint != null ? Double.valueOf(geoPoint.getLat()) : null;
                    Intrinsics.checkNotNull((Object)d);
                    double d2 = d;
                    GeoPoint geoPoint2 = step.getStartLocation();
                    Double d3 = geoPoint2 != null ? Double.valueOf(geoPoint2.getLng()) : null;
                    Intrinsics.checkNotNull((Object)d3);
                    polylineOptions.add(new LatLng(d2, d3.doubleValue()));
                    polylineOptions.width((float)this.pathWidth);
                    polylineOptions.color(this.pathColor);
                    this.googleMap.addPolyline(polylineOptions);
                }
            }
        }
    }

    private RouteDrawer(RouteDrawerBuilder builder) {
        this.googleMap = builder.getGoogleMap$drawroute_release();
        this.alpha = builder.getAlpha$drawroute_release();
        this.pathWidth = builder.getPathWidth$drawroute_release();
        this.pathColor = builder.getPathColor$drawroute_release();
        this.bitmapDescriptor = builder.getBitmapDescriptor$drawroute_release();
    }

    public /* synthetic */ RouteDrawer(RouteDrawerBuilder builder, DefaultConstructorMarker $constructor_marker) {
        this(builder);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018\u00a8\u0006\""}, d2={"Lcom/maps/route/RouteDrawer$RouteDrawerBuilder;", "", "googleMap", "Lcom/google/android/gms/maps/GoogleMap;", "(Lcom/google/android/gms/maps/GoogleMap;)V", "alpha", "", "getAlpha$drawroute_release", "()F", "setAlpha$drawroute_release", "(F)V", "bitmapDescriptor", "Lcom/google/android/gms/maps/model/BitmapDescriptor;", "getBitmapDescriptor$drawroute_release", "()Lcom/google/android/gms/maps/model/BitmapDescriptor;", "setBitmapDescriptor$drawroute_release", "(Lcom/google/android/gms/maps/model/BitmapDescriptor;)V", "getGoogleMap$drawroute_release", "()Lcom/google/android/gms/maps/GoogleMap;", "pathColor", "", "getPathColor$drawroute_release", "()I", "setPathColor$drawroute_release", "(I)V", "pathWidth", "getPathWidth$drawroute_release", "setPathWidth$drawroute_release", "build", "Lcom/maps/route/RouteDrawer;", "withAlpha", "withColor", "withMarkerIcon", "withWidth", "drawroute_release"})
    public static final class RouteDrawerBuilder {
        @NotNull
        private BitmapDescriptor bitmapDescriptor;
        private int pathWidth;
        private int pathColor;
        private float alpha;
        @NotNull
        private final GoogleMap googleMap;

        @NotNull
        public final BitmapDescriptor getBitmapDescriptor$drawroute_release() {
            return this.bitmapDescriptor;
        }

        public final void setBitmapDescriptor$drawroute_release(@NotNull BitmapDescriptor bitmapDescriptor) {
            Intrinsics.checkNotNullParameter((Object)bitmapDescriptor, (String)"<set-?>");
            this.bitmapDescriptor = bitmapDescriptor;
        }

        public final int getPathWidth$drawroute_release() {
            return this.pathWidth;
        }

        public final void setPathWidth$drawroute_release(int n) {
            this.pathWidth = n;
        }

        public final int getPathColor$drawroute_release() {
            return this.pathColor;
        }

        public final void setPathColor$drawroute_release(int n) {
            this.pathColor = n;
        }

        public final float getAlpha$drawroute_release() {
            return this.alpha;
        }

        public final void setAlpha$drawroute_release(float f) {
            this.alpha = f;
        }

        @NotNull
        public final RouteDrawerBuilder withColor(int pathColor) {
            this.pathColor = pathColor;
            return this;
        }

        @NotNull
        public final RouteDrawerBuilder withWidth(int pathWidth) {
            this.pathWidth = pathWidth;
            return this;
        }

        @NotNull
        public final RouteDrawerBuilder withMarkerIcon(@NotNull BitmapDescriptor bitmapDescriptor) {
            Intrinsics.checkNotNullParameter((Object)bitmapDescriptor, (String)"bitmapDescriptor");
            this.bitmapDescriptor = bitmapDescriptor;
            return this;
        }

        @NotNull
        public final RouteDrawerBuilder withAlpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        @NotNull
        public final RouteDrawer build() {
            return new RouteDrawer(this, null);
        }

        @NotNull
        public final GoogleMap getGoogleMap$drawroute_release() {
            return this.googleMap;
        }

        public RouteDrawerBuilder(@NotNull GoogleMap googleMap) {
            Intrinsics.checkNotNullParameter((Object)googleMap, (String)"googleMap");
            this.googleMap = googleMap;
            this.pathWidth = 5;
            this.pathColor = -65536;
            this.alpha = 1.0f;
            BitmapDescriptor bitmapDescriptor = BitmapDescriptorFactory.defaultMarker((float)210.0f);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapDescriptor, (String)"BitmapDescriptorFactory.\u2026criptorFactory.HUE_AZURE)");
            this.bitmapDescriptor = bitmapDescriptor;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/maps/route/RouteDrawer$Companion;", "", "()V", "DEFAULT_MARKER_ALPHA", "", "DEFAULT_PATH_COLOR", "", "DEFAULT_PATH_WIDTH", "drawroute_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

