/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fernandospr.wns.model.builders;

import ar.com.fernandospr.wns.model.WnsBinding;
import ar.com.fernandospr.wns.model.WnsImage;
import ar.com.fernandospr.wns.model.WnsText;
import ar.com.fernandospr.wns.model.WnsVisual;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WnsAbstractBuilder<T extends WnsAbstractBuilder<T>> {
    protected abstract T getThis();

    protected abstract WnsVisual getVisual();

    protected abstract WnsBinding getBinding();

    public T visualVersion(Integer version) {
        this.getVisual().version = version;
        return this.getThis();
    }

    public T visualLang(String lang) {
        this.getVisual().lang = lang;
        return this.getThis();
    }

    public T visualBaseUri(String baseUri) {
        this.getVisual().baseUri = baseUri;
        return this.getThis();
    }

    public T visualBranding(String branding) {
        this.getVisual().branding = branding;
        return this.getThis();
    }

    public T visualAddImageQuery(Boolean addImageQuery) {
        this.getVisual().addImageQuery = addImageQuery;
        return this.getThis();
    }

    public T bindingFallback(String fallback) {
        this.getBinding().fallback = fallback;
        return this.getThis();
    }

    public T bindingLang(String lang) {
        this.getBinding().lang = lang;
        return this.getThis();
    }

    public T bindingBaseUri(String baseUri) {
        this.getBinding().baseUri = baseUri;
        return this.getThis();
    }

    public T bindingBranding(String branding) {
        this.getBinding().branding = branding;
        return this.getThis();
    }

    public T bindingAddImageQuery(Boolean addImageQuery) {
        this.getBinding().addImageQuery = addImageQuery;
        return this.getThis();
    }

    protected T bindingTemplate(String template) {
        this.getBinding().template = template;
        this.getBinding().texts = null;
        this.getBinding().images = null;
        return this.getThis();
    }

    protected T setBindingTextFields(String ... textFields) {
        this.getBinding().texts = new ArrayList<WnsText>();
        int i = 0;
        while (i < textFields.length) {
            WnsText txt = new WnsText();
            txt.id = i + 1;
            txt.value = textFields[i] != null ? textFields[i] : "";
            this.getBinding().texts.add(txt);
            ++i;
        }
        return this.getThis();
    }

    protected T setBindingImages(String ... imgSrcs) {
        this.getBinding().images = new ArrayList<WnsImage>();
        int i = 0;
        while (i < imgSrcs.length) {
            WnsImage img = new WnsImage();
            img.id = i + 1;
            img.src = imgSrcs[i] != null ? imgSrcs[i] : "";
            this.getBinding().images.add(img);
            ++i;
        }
        return this.getThis();
    }
}

