/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.core;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class TLVector<T>
extends TLObject
implements List<T> {
    public static final int CONSTRUCTOR_ID = 481674261;
    protected final Class itemClazz;
    protected final ArrayList<T> items = new ArrayList();

    public TLVector() {
        this.itemClazz = TLObject.class;
    }

    public TLVector(Class<T> destClass) {
        if (destClass != null) {
            if (destClass != Integer.class && destClass != Long.class && destClass != String.class && !TLObject.class.isAssignableFrom(destClass)) {
                throw new RuntimeException("Unsupported vector type: " + destClass.getSimpleName());
            }
            this.itemClazz = destClass;
        } else {
            this.itemClazz = TLObject.class;
        }
    }

    public String toString() {
        return "vector#1cb5c415";
    }

    @Override
    public int getConstructorId() {
        return 481674261;
    }

    @Override
    public final void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.items.size(), stream);
        for (T i : this.items) {
            this.serializeItem(i, stream);
        }
    }

    protected void serializeItem(T item, OutputStream stream) throws IOException {
        StreamUtils.writeTLObject((TLObject)item, stream);
    }

    @Override
    public final void deserializeBody(InputStream stream, TLContext context) throws IOException {
        int count = StreamUtils.readInt(stream);
        for (int i = 0; i < count; ++i) {
            this.items.add(this.deserializeItem(stream, context));
        }
    }

    protected T deserializeItem(InputStream stream, TLContext context) throws IOException {
        return (T)context.deserializeMessage(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID + TLObjectUtils.SIZE_INT32;
        for (T item : this.items) {
            size += ((TLObject)item).computeSerializedSize();
        }
        return size;
    }

    public void trimToSize() {
        this.items.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.items.ensureCapacity(minCapacity);
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    @Override
    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    public Object clone() {
        TLVector<T> vector = new TLVector<T>();
        vector.addAll((Collection<T>)new ArrayList<T>(this.items));
        return vector;
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.items.toArray(a);
    }

    @Override
    public T get(int index) {
        return this.items.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.items.set(index, element);
    }

    @Override
    public boolean add(T t) {
        return this.items.add(t);
    }

    @Override
    public void add(int index, T element) {
        this.items.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.items.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.items.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.items.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.items.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.items.retainAll(c);
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.items.listIterator();
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.items.forEach((Consumer<T>)action);
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.items.spliterator();
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        return this.items.removeIf(filter);
    }

    @Override
    public void replaceAll(UnaryOperator<T> operator) {
        this.items.replaceAll(operator);
    }

    @Override
    public void sort(Comparator<? super T> c) {
        this.items.sort(c);
    }

    @Override
    public int hashCode() {
        return this.items.hashCode();
    }

    @Override
    public Stream<T> stream() {
        return this.items.stream();
    }

    @Override
    public Stream<T> parallelStream() {
        return this.items.parallelStream();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.items.containsAll(c);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof TLVector)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TLVector o = (TLVector)obj;
        return this.size() == o.size() || this.items.equals(o.items);
    }
}

