/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.core;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLStringVector
extends TLVector<String> {
    public TLStringVector() {
        super(String.class);
    }

    @Override
    protected void serializeItem(String item, OutputStream stream) throws IOException {
        StreamUtils.writeString(item, stream);
    }

    @Override
    protected String deserializeItem(InputStream stream, TLContext context) throws IOException {
        return StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID + TLObjectUtils.SIZE_INT32;
        for (String item : this.items) {
            size += TLObjectUtils.computeTLStringSerializedSize(item);
        }
        return size;
    }

    @Override
    public String toString() {
        return "vector<string>#1cb5c415";
    }
}

