/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.core;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.exception.InvalidConstructorIdException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public abstract class TLObject
implements Serializable {
    public abstract int getConstructorId();

    public final byte[] serialize() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(this.computeSerializedSize());
        this.serialize(stream);
        return stream.toByteArray();
    }

    public final void serialize(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.getConstructorId(), stream);
        this.serializeBody(stream);
    }

    public final void deserialize(InputStream stream, TLContext context) throws IOException {
        int constructorId = StreamUtils.readInt(stream);
        if (constructorId != this.getConstructorId()) {
            throw new InvalidConstructorIdException(constructorId, this.getConstructorId());
        }
        this.deserializeBody(stream, context);
    }

    public void serializeBody(OutputStream stream) throws IOException {
    }

    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
    }

    public int computeSerializedSize() {
        return 4;
    }
}

