/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.core;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLLongVector
extends TLVector<Long> {
    public TLLongVector() {
        super(Long.class);
    }

    @Override
    protected void serializeItem(Long item, OutputStream stream) throws IOException {
        StreamUtils.writeLong(item, stream);
    }

    @Override
    protected Long deserializeItem(InputStream stream, TLContext context) throws IOException {
        return StreamUtils.readLong(stream);
    }

    @Override
    public int computeSerializedSize() {
        return TLObjectUtils.SIZE_CONSTRUCTOR_ID + TLObjectUtils.SIZE_INT32 + TLObjectUtils.SIZE_INT64 * this.size();
    }

    @Override
    public String toString() {
        return "vector<long>#1cb5c415";
    }

    public long[] toLongArray() {
        long[] array = new long[this.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Long)this.items.get(i);
        }
        return array;
    }
}

