/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.core;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class TLGzipObject
extends TLObject {
    public static final int CONSTRUCTOR_ID = 812830625;
    private byte[] packedData;

    public TLGzipObject() {
    }

    public TLGzipObject(byte[] packedData) {
        this.packedData = packedData;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLBytes(this.packedData, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.packedData = StreamUtils.readTLBytes(stream);
    }

    @Override
    public int computeSerializedSize() {
        return 812830625 + TLObjectUtils.computeTLBytesSerializedSize(this.packedData.length);
    }

    public String toString() {
        return "gzip_packed#3072cfa1";
    }

    @Override
    public int getConstructorId() {
        return 812830625;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TLGzipObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TLGzipObject o = (TLGzipObject)obj;
        return Arrays.equals(this.packedData, o.packedData);
    }

    public byte[] getPackedData() {
        return this.packedData;
    }

    public void setPackedData(byte[] packedData) {
        this.packedData = packedData;
    }
}

