/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.core;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.core.TLObject;
import com.github.badoualy.telegram.tl.exception.InvalidConstructorIdException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class TLBool
extends TLObject {
    public static final TLBool TRUE = new TLBoolTrue();
    public static final TLBool FALSE = new TLBoolFalse();
    public static final int TRUE_CONSTRUCTOR_ID = -1720552011;
    public static final int FALSE_CONSTRUCTOR_ID = -1132882121;

    public static TLBool get(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static void serialize(boolean value, OutputStream stream) throws IOException {
        TLBool.get(value).serialize(stream);
    }

    public static boolean deserialize(InputStream stream) throws IOException {
        int constructorId = StreamUtils.readInt(stream);
        if (constructorId == -1720552011) {
            return true;
        }
        if (constructorId == -1132882121) {
            return false;
        }
        throw new InvalidConstructorIdException("Wrong TLBool constructor id. Found " + Integer.toHexString(constructorId) + ", expected: " + Integer.toHexString(-1720552011) + " or " + Integer.toHexString(-1132882121));
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    private static final class TLBoolFalse
    extends TLBool {
        public static final int CONSTRUCTOR_ID = -1132882121;

        private TLBoolFalse() {
        }

        @Override
        public int getConstructorId() {
            return -1132882121;
        }

        public String toString() {
            return "boolFalse#bc799737";
        }
    }

    private static final class TLBoolTrue
    extends TLBool {
        public static final int CONSTRUCTOR_ID = -1720552011;

        private TLBoolTrue() {
        }

        @Override
        public int getConstructorId() {
            return -1720552011;
        }

        public String toString() {
            return "boolTrue#997275b5";
        }
    }
}

