/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.upload;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.storage.TLAbsFileType;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLFile
extends TLObject {
    public static final int CONSTRUCTOR_ID = 157948117;
    protected TLAbsFileType type;
    protected int mtime;
    protected TLBytes bytes;
    private final String _constructor = "upload.file#96a18d5";

    public TLFile() {
    }

    public TLFile(TLAbsFileType type, int mtime, TLBytes bytes) {
        this.type = type;
        this.mtime = mtime;
        this.bytes = bytes;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.type, stream);
        StreamUtils.writeInt(this.mtime, stream);
        StreamUtils.writeTLBytes(this.bytes, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.type = StreamUtils.readTLObject(stream, context, TLAbsFileType.class, -1);
        this.mtime = StreamUtils.readInt(stream);
        this.bytes = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.type.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.bytes);
    }

    public String toString() {
        return "upload.file#96a18d5";
    }

    @Override
    public int getConstructorId() {
        return 157948117;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLFile)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLFile o = (TLFile)object;
        return (this.type == o.type || this.type != null && o.type != null && this.type.equals(o.type)) && this.mtime == o.mtime && (this.bytes == o.bytes || this.bytes != null && o.bytes != null && this.bytes.equals(o.bytes));
    }

    public TLAbsFileType getType() {
        return this.type;
    }

    public void setType(TLAbsFileType type) {
        this.type = type;
    }

    public int getMtime() {
        return this.mtime;
    }

    public void setMtime(int mtime) {
        this.mtime = mtime;
    }

    public TLBytes getBytes() {
        return this.bytes;
    }

    public void setBytes(TLBytes bytes) {
        this.bytes = bytes;
    }
}

