/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputFileLocation;
import com.github.badoualy.telegram.tl.api.upload.TLFile;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestUploadGetFile
extends TLMethod<TLFile> {
    public static final int CONSTRUCTOR_ID = -475607115;
    protected TLAbsInputFileLocation location;
    protected int offset;
    protected int limit;
    private final String _constructor = "upload.getFile#e3a6cfb5";

    public TLRequestUploadGetFile() {
    }

    public TLRequestUploadGetFile(TLAbsInputFileLocation location, int offset, int limit) {
        this.location = location;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public TLFile deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLFile)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLFile)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.location, stream);
        StreamUtils.writeInt(this.offset, stream);
        StreamUtils.writeInt(this.limit, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.location = StreamUtils.readTLObject(stream, context, TLAbsInputFileLocation.class, -1);
        this.offset = StreamUtils.readInt(stream);
        this.limit = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.location.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "upload.getFile#e3a6cfb5";
    }

    @Override
    public int getConstructorId() {
        return -475607115;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestUploadGetFile)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestUploadGetFile o = (TLRequestUploadGetFile)object;
        return (this.location == o.location || this.location != null && o.location != null && this.location.equals(o.location)) && this.offset == o.offset && this.limit == o.limit;
    }

    public TLAbsInputFileLocation getLocation() {
        return this.location;
    }

    public void setLocation(TLAbsInputFileLocation location) {
        this.location = location;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

