/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputFile;
import com.github.badoualy.telegram.tl.api.TLAbsInputGeoPoint;
import com.github.badoualy.telegram.tl.api.TLAbsInputPhotoCrop;
import com.github.badoualy.telegram.tl.api.photos.TLPhoto;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestPhotosUploadProfilePhoto
extends TLMethod<TLPhoto> {
    public static final int CONSTRUCTOR_ID = -720397176;
    protected TLAbsInputFile file;
    protected String caption;
    protected TLAbsInputGeoPoint geoPoint;
    protected TLAbsInputPhotoCrop crop;
    private final String _constructor = "photos.uploadProfilePhoto#d50f9c88";

    public TLRequestPhotosUploadProfilePhoto() {
    }

    public TLRequestPhotosUploadProfilePhoto(TLAbsInputFile file, String caption, TLAbsInputGeoPoint geoPoint, TLAbsInputPhotoCrop crop) {
        this.file = file;
        this.caption = caption;
        this.geoPoint = geoPoint;
        this.crop = crop;
    }

    @Override
    public TLPhoto deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLPhoto)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLPhoto)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.file, stream);
        StreamUtils.writeString(this.caption, stream);
        StreamUtils.writeTLObject(this.geoPoint, stream);
        StreamUtils.writeTLObject(this.crop, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.file = StreamUtils.readTLObject(stream, context, TLAbsInputFile.class, -1);
        this.caption = StreamUtils.readTLString(stream);
        this.geoPoint = StreamUtils.readTLObject(stream, context, TLAbsInputGeoPoint.class, -1);
        this.crop = StreamUtils.readTLObject(stream, context, TLAbsInputPhotoCrop.class, -1);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.file.computeSerializedSize();
        size += TLObjectUtils.computeTLStringSerializedSize(this.caption);
        size += this.geoPoint.computeSerializedSize();
        return size += this.crop.computeSerializedSize();
    }

    public String toString() {
        return "photos.uploadProfilePhoto#d50f9c88";
    }

    @Override
    public int getConstructorId() {
        return -720397176;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestPhotosUploadProfilePhoto)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestPhotosUploadProfilePhoto o = (TLRequestPhotosUploadProfilePhoto)object;
        return (this.file == o.file || this.file != null && o.file != null && this.file.equals(o.file)) && (this.caption == o.caption || this.caption != null && o.caption != null && this.caption.equals(o.caption)) && (this.geoPoint == o.geoPoint || this.geoPoint != null && o.geoPoint != null && this.geoPoint.equals(o.geoPoint)) && (this.crop == o.crop || this.crop != null && o.crop != null && this.crop.equals(o.crop));
    }

    public TLAbsInputFile getFile() {
        return this.file;
    }

    public void setFile(TLAbsInputFile file) {
        this.file = file;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public TLAbsInputGeoPoint getGeoPoint() {
        return this.geoPoint;
    }

    public void setGeoPoint(TLAbsInputGeoPoint geoPoint) {
        this.geoPoint = geoPoint;
    }

    public TLAbsInputPhotoCrop getCrop() {
        return this.crop;
    }

    public void setCrop(TLAbsInputPhotoCrop crop) {
        this.crop = crop;
    }
}

