/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import com.github.badoualy.telegram.tl.api.TLAbsInputUser;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesStartBot
extends TLMethod<TLAbsUpdates> {
    public static final int CONSTRUCTOR_ID = -421563528;
    protected TLAbsInputUser bot;
    protected TLAbsInputPeer peer;
    protected long randomId;
    protected String startParam;
    private final String _constructor = "messages.startBot#e6df7378";

    public TLRequestMessagesStartBot() {
    }

    public TLRequestMessagesStartBot(TLAbsInputUser bot, TLAbsInputPeer peer, long randomId, String startParam) {
        this.bot = bot;
        this.peer = peer;
        this.randomId = randomId;
        this.startParam = startParam;
    }

    @Override
    public TLAbsUpdates deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsUpdates)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsUpdates)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.bot, stream);
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeLong(this.randomId, stream);
        StreamUtils.writeString(this.startParam, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.bot = StreamUtils.readTLObject(stream, context, TLAbsInputUser.class, -1);
        this.peer = StreamUtils.readTLObject(stream, context, TLAbsInputPeer.class, -1);
        this.randomId = StreamUtils.readLong(stream);
        this.startParam = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.bot.computeSerializedSize();
        size += this.peer.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT64;
        return size += TLObjectUtils.computeTLStringSerializedSize(this.startParam);
    }

    public String toString() {
        return "messages.startBot#e6df7378";
    }

    @Override
    public int getConstructorId() {
        return -421563528;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesStartBot)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesStartBot o = (TLRequestMessagesStartBot)object;
        return (this.bot == o.bot || this.bot != null && o.bot != null && this.bot.equals(o.bot)) && (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && this.randomId == o.randomId && (this.startParam == o.startParam || this.startParam != null && o.startParam != null && this.startParam.equals(o.startParam));
    }

    public TLAbsInputUser getBot() {
        return this.bot;
    }

    public void setBot(TLAbsInputUser bot) {
        this.bot = bot;
    }

    public TLAbsInputPeer getPeer() {
        return this.peer;
    }

    public void setPeer(TLAbsInputPeer peer) {
        this.peer = peer;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    public String getStartParam() {
        return this.startParam;
    }

    public void setStartParam(String startParam) {
        this.startParam = startParam;
    }
}

