/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputMedia;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import com.github.badoualy.telegram.tl.api.TLAbsReplyMarkup;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesSendMedia
extends TLMethod<TLAbsUpdates> {
    public static final int CONSTRUCTOR_ID = -923703407;
    protected int flags;
    protected boolean broadcast;
    protected TLAbsInputPeer peer;
    protected Integer replyToMsgId;
    protected TLAbsInputMedia media;
    protected long randomId;
    protected TLAbsReplyMarkup replyMarkup;
    private final String _constructor = "messages.sendMedia#c8f16791";

    public TLRequestMessagesSendMedia() {
    }

    public TLRequestMessagesSendMedia(boolean broadcast, TLAbsInputPeer peer, Integer replyToMsgId, TLAbsInputMedia media, long randomId, TLAbsReplyMarkup replyMarkup) {
        this.broadcast = broadcast;
        this.peer = peer;
        this.replyToMsgId = replyToMsgId;
        this.media = media;
        this.randomId = randomId;
        this.replyMarkup = replyMarkup;
    }

    @Override
    public TLAbsUpdates deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsUpdates)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsUpdates)response;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.broadcast ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.replyToMsgId != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.replyMarkup != null ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeTLObject(this.peer, stream);
        if ((this.flags & 1) != 0) {
            StreamUtils.writeInt(this.replyToMsgId, stream);
        }
        StreamUtils.writeTLObject(this.media, stream);
        StreamUtils.writeLong(this.randomId, stream);
        if ((this.flags & 4) != 0) {
            StreamUtils.writeTLObject(this.replyMarkup, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.broadcast = (this.flags & 0x10) != 0;
        this.peer = StreamUtils.readTLObject(stream, context, TLAbsInputPeer.class, -1);
        this.replyToMsgId = (this.flags & 1) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.media = StreamUtils.readTLObject(stream, context, TLAbsInputMedia.class, -1);
        this.randomId = StreamUtils.readLong(stream);
        this.replyMarkup = (this.flags & 4) != 0 ? StreamUtils.readTLObject(stream, context, TLAbsReplyMarkup.class, -1) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += this.peer.computeSerializedSize();
        if ((this.flags & 1) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        size += this.media.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT64;
        if ((this.flags & 4) != 0) {
            size += this.replyMarkup.computeSerializedSize();
        }
        return size;
    }

    public String toString() {
        return "messages.sendMedia#c8f16791";
    }

    @Override
    public int getConstructorId() {
        return -923703407;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesSendMedia)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesSendMedia o = (TLRequestMessagesSendMedia)object;
        return this.flags == o.flags && this.broadcast == o.broadcast && (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && (this.replyToMsgId == o.replyToMsgId || this.replyToMsgId != null && o.replyToMsgId != null && this.replyToMsgId.equals(o.replyToMsgId)) && (this.media == o.media || this.media != null && o.media != null && this.media.equals(o.media)) && this.randomId == o.randomId && (this.replyMarkup == o.replyMarkup || this.replyMarkup != null && o.replyMarkup != null && this.replyMarkup.equals(o.replyMarkup));
    }

    public boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public TLAbsInputPeer getPeer() {
        return this.peer;
    }

    public void setPeer(TLAbsInputPeer peer) {
        this.peer = peer;
    }

    public Integer getReplyToMsgId() {
        return this.replyToMsgId;
    }

    public void setReplyToMsgId(Integer replyToMsgId) {
        this.replyToMsgId = replyToMsgId;
    }

    public TLAbsInputMedia getMedia() {
        return this.media;
    }

    public void setMedia(TLAbsInputMedia media) {
        this.media = media;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    public TLAbsReplyMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public void setReplyMarkup(TLAbsReplyMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }
}

