/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesSendInlineBotResult
extends TLMethod<TLAbsUpdates> {
    public static final int CONSTRUCTOR_ID = -1318189314;
    protected int flags;
    protected boolean broadcast;
    protected TLAbsInputPeer peer;
    protected Integer replyToMsgId;
    protected long randomId;
    protected long queryId;
    protected String id;
    private final String _constructor = "messages.sendInlineBotResult#b16e06fe";

    public TLRequestMessagesSendInlineBotResult() {
    }

    public TLRequestMessagesSendInlineBotResult(boolean broadcast, TLAbsInputPeer peer, Integer replyToMsgId, long randomId, long queryId, String id) {
        this.broadcast = broadcast;
        this.peer = peer;
        this.replyToMsgId = replyToMsgId;
        this.randomId = randomId;
        this.queryId = queryId;
        this.id = id;
    }

    @Override
    public TLAbsUpdates deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsUpdates)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsUpdates)response;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.broadcast ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
        this.flags = this.replyToMsgId != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeTLObject(this.peer, stream);
        if ((this.flags & 1) != 0) {
            StreamUtils.writeInt(this.replyToMsgId, stream);
        }
        StreamUtils.writeLong(this.randomId, stream);
        StreamUtils.writeLong(this.queryId, stream);
        StreamUtils.writeString(this.id, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.broadcast = (this.flags & 0x10) != 0;
        this.peer = StreamUtils.readTLObject(stream, context, TLAbsInputPeer.class, -1);
        this.replyToMsgId = (this.flags & 1) != 0 ? Integer.valueOf(StreamUtils.readInt(stream)) : null;
        this.randomId = StreamUtils.readLong(stream);
        this.queryId = StreamUtils.readLong(stream);
        this.id = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += this.peer.computeSerializedSize();
        if ((this.flags & 1) != 0) {
            size += TLObjectUtils.SIZE_INT32;
        }
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT64;
        return size += TLObjectUtils.computeTLStringSerializedSize(this.id);
    }

    public String toString() {
        return "messages.sendInlineBotResult#b16e06fe";
    }

    @Override
    public int getConstructorId() {
        return -1318189314;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesSendInlineBotResult)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesSendInlineBotResult o = (TLRequestMessagesSendInlineBotResult)object;
        return this.flags == o.flags && this.broadcast == o.broadcast && (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && (this.replyToMsgId == o.replyToMsgId || this.replyToMsgId != null && o.replyToMsgId != null && this.replyToMsgId.equals(o.replyToMsgId)) && this.randomId == o.randomId && this.queryId == o.queryId && (this.id == o.id || this.id != null && o.id != null && this.id.equals(o.id));
    }

    public boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public TLAbsInputPeer getPeer() {
        return this.peer;
    }

    public void setPeer(TLAbsInputPeer peer) {
        this.peer = peer;
    }

    public Integer getReplyToMsgId() {
        return this.replyToMsgId;
    }

    public void setReplyToMsgId(Integer replyToMsgId) {
        this.replyToMsgId = replyToMsgId;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public void setQueryId(long queryId) {
        this.queryId = queryId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

