/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputEncryptedFile;
import com.github.badoualy.telegram.tl.api.TLInputEncryptedChat;
import com.github.badoualy.telegram.tl.api.messages.TLAbsSentEncryptedMessage;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesSendEncryptedFile
extends TLMethod<TLAbsSentEncryptedMessage> {
    public static final int CONSTRUCTOR_ID = -1701831834;
    protected TLInputEncryptedChat peer;
    protected long randomId;
    protected TLBytes data;
    protected TLAbsInputEncryptedFile file;
    private final String _constructor = "messages.sendEncryptedFile#9a901b66";

    public TLRequestMessagesSendEncryptedFile() {
    }

    public TLRequestMessagesSendEncryptedFile(TLInputEncryptedChat peer, long randomId, TLBytes data, TLAbsInputEncryptedFile file) {
        this.peer = peer;
        this.randomId = randomId;
        this.data = data;
        this.file = file;
    }

    @Override
    public TLAbsSentEncryptedMessage deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsSentEncryptedMessage)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsSentEncryptedMessage)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeLong(this.randomId, stream);
        StreamUtils.writeTLBytes(this.data, stream);
        StreamUtils.writeTLObject(this.file, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.peer = StreamUtils.readTLObject(stream, context, TLInputEncryptedChat.class, -247351839);
        this.randomId = StreamUtils.readLong(stream);
        this.data = StreamUtils.readTLBytes(stream, context);
        this.file = StreamUtils.readTLObject(stream, context, TLAbsInputEncryptedFile.class, -1);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.peer.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.computeTLBytesSerializedSize(this.data);
        return size += this.file.computeSerializedSize();
    }

    public String toString() {
        return "messages.sendEncryptedFile#9a901b66";
    }

    @Override
    public int getConstructorId() {
        return -1701831834;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesSendEncryptedFile)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesSendEncryptedFile o = (TLRequestMessagesSendEncryptedFile)object;
        return (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && this.randomId == o.randomId && (this.data == o.data || this.data != null && o.data != null && this.data.equals(o.data)) && (this.file == o.file || this.file != null && o.file != null && this.file.equals(o.file));
    }

    public TLInputEncryptedChat getPeer() {
        return this.peer;
    }

    public void setPeer(TLInputEncryptedChat peer) {
        this.peer = peer;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    public TLBytes getData() {
        return this.data;
    }

    public void setData(TLBytes data) {
        this.data = data;
    }

    public TLAbsInputEncryptedFile getFile() {
        return this.file;
    }

    public void setFile(TLAbsInputEncryptedFile file) {
        this.file = file;
    }
}

