/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLInputEncryptedChat;
import com.github.badoualy.telegram.tl.api.messages.TLAbsSentEncryptedMessage;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesSendEncrypted
extends TLMethod<TLAbsSentEncryptedMessage> {
    public static final int CONSTRUCTOR_ID = -1451792525;
    protected TLInputEncryptedChat peer;
    protected long randomId;
    protected TLBytes data;
    private final String _constructor = "messages.sendEncrypted#a9776773";

    public TLRequestMessagesSendEncrypted() {
    }

    public TLRequestMessagesSendEncrypted(TLInputEncryptedChat peer, long randomId, TLBytes data) {
        this.peer = peer;
        this.randomId = randomId;
        this.data = data;
    }

    @Override
    public TLAbsSentEncryptedMessage deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsSentEncryptedMessage)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsSentEncryptedMessage)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeLong(this.randomId, stream);
        StreamUtils.writeTLBytes(this.data, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.peer = StreamUtils.readTLObject(stream, context, TLInputEncryptedChat.class, -247351839);
        this.randomId = StreamUtils.readLong(stream);
        this.data = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.peer.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT64;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.data);
    }

    public String toString() {
        return "messages.sendEncrypted#a9776773";
    }

    @Override
    public int getConstructorId() {
        return -1451792525;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesSendEncrypted)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesSendEncrypted o = (TLRequestMessagesSendEncrypted)object;
        return (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && this.randomId == o.randomId && (this.data == o.data || this.data != null && o.data != null && this.data.equals(o.data));
    }

    public TLInputEncryptedChat getPeer() {
        return this.peer;
    }

    public void setPeer(TLInputEncryptedChat peer) {
        this.peer = peer;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }

    public TLBytes getData() {
        return this.data;
    }

    public void setData(TLBytes data) {
        this.data = data;
    }
}

