/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import com.github.badoualy.telegram.tl.api.TLAbsMessagesFilter;
import com.github.badoualy.telegram.tl.api.messages.TLAbsMessages;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesSearch
extends TLMethod<TLAbsMessages> {
    public static final int CONSTRUCTOR_ID = -732523960;
    protected int flags;
    protected boolean importantOnly;
    protected TLAbsInputPeer peer;
    protected String q;
    protected TLAbsMessagesFilter filter;
    protected int minDate;
    protected int maxDate;
    protected int offset;
    protected int maxId;
    protected int limit;
    private final String _constructor = "messages.search#d4569248";

    public TLRequestMessagesSearch() {
    }

    public TLRequestMessagesSearch(boolean importantOnly, TLAbsInputPeer peer, String q, TLAbsMessagesFilter filter, int minDate, int maxDate, int offset, int maxId, int limit) {
        this.importantOnly = importantOnly;
        this.peer = peer;
        this.q = q;
        this.filter = filter;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.offset = offset;
        this.maxId = maxId;
        this.limit = limit;
    }

    @Override
    public TLAbsMessages deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsMessages)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsMessages)response;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.importantOnly ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeString(this.q, stream);
        StreamUtils.writeTLObject(this.filter, stream);
        StreamUtils.writeInt(this.minDate, stream);
        StreamUtils.writeInt(this.maxDate, stream);
        StreamUtils.writeInt(this.offset, stream);
        StreamUtils.writeInt(this.maxId, stream);
        StreamUtils.writeInt(this.limit, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.importantOnly = (this.flags & 1) != 0;
        this.peer = StreamUtils.readTLObject(stream, context, TLAbsInputPeer.class, -1);
        this.q = StreamUtils.readTLString(stream);
        this.filter = StreamUtils.readTLObject(stream, context, TLAbsMessagesFilter.class, -1);
        this.minDate = StreamUtils.readInt(stream);
        this.maxDate = StreamUtils.readInt(stream);
        this.offset = StreamUtils.readInt(stream);
        this.maxId = StreamUtils.readInt(stream);
        this.limit = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += this.peer.computeSerializedSize();
        size += TLObjectUtils.computeTLStringSerializedSize(this.q);
        size += this.filter.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "messages.search#d4569248";
    }

    @Override
    public int getConstructorId() {
        return -732523960;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesSearch)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesSearch o = (TLRequestMessagesSearch)object;
        return this.flags == o.flags && this.importantOnly == o.importantOnly && (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && (this.q == o.q || this.q != null && o.q != null && this.q.equals(o.q)) && (this.filter == o.filter || this.filter != null && o.filter != null && this.filter.equals(o.filter)) && this.minDate == o.minDate && this.maxDate == o.maxDate && this.offset == o.offset && this.maxId == o.maxId && this.limit == o.limit;
    }

    public boolean getImportantOnly() {
        return this.importantOnly;
    }

    public void setImportantOnly(boolean importantOnly) {
        this.importantOnly = importantOnly;
    }

    public TLAbsInputPeer getPeer() {
        return this.peer;
    }

    public void setPeer(TLAbsInputPeer peer) {
        this.peer = peer;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public TLAbsMessagesFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TLAbsMessagesFilter filter) {
        this.filter = filter;
    }

    public int getMinDate() {
        return this.minDate;
    }

    public void setMinDate(int minDate) {
        this.minDate = minDate;
    }

    public int getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(int maxDate) {
        this.maxDate = maxDate;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getMaxId() {
        return this.maxId;
    }

    public void setMaxId(int maxId) {
        this.maxId = maxId;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

