/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsEncryptedChat;
import com.github.badoualy.telegram.tl.api.TLAbsInputUser;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesRequestEncryption
extends TLMethod<TLAbsEncryptedChat> {
    public static final int CONSTRUCTOR_ID = -162681021;
    protected TLAbsInputUser userId;
    protected int randomId;
    protected TLBytes gA;
    private final String _constructor = "messages.requestEncryption#f64daf43";

    public TLRequestMessagesRequestEncryption() {
    }

    public TLRequestMessagesRequestEncryption(TLAbsInputUser userId, int randomId, TLBytes gA) {
        this.userId = userId;
        this.randomId = randomId;
        this.gA = gA;
    }

    @Override
    public TLAbsEncryptedChat deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsEncryptedChat)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsEncryptedChat)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.userId, stream);
        StreamUtils.writeInt(this.randomId, stream);
        StreamUtils.writeTLBytes(this.gA, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.userId = StreamUtils.readTLObject(stream, context, TLAbsInputUser.class, -1);
        this.randomId = StreamUtils.readInt(stream);
        this.gA = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.userId.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.gA);
    }

    public String toString() {
        return "messages.requestEncryption#f64daf43";
    }

    @Override
    public int getConstructorId() {
        return -162681021;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesRequestEncryption)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesRequestEncryption o = (TLRequestMessagesRequestEncryption)object;
        return (this.userId == o.userId || this.userId != null && o.userId != null && this.userId.equals(o.userId)) && this.randomId == o.randomId && (this.gA == o.gA || this.gA != null && o.gA != null && this.gA.equals(o.gA));
    }

    public TLAbsInputUser getUserId() {
        return this.userId;
    }

    public void setUserId(TLAbsInputUser userId) {
        this.userId = userId;
    }

    public int getRandomId() {
        return this.randomId;
    }

    public void setRandomId(int randomId) {
        this.randomId = randomId;
    }

    public TLBytes getGA() {
        return this.gA;
    }

    public void setGA(TLBytes gA) {
        this.gA = gA;
    }
}

