/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLInputEncryptedChat;
import com.github.badoualy.telegram.tl.core.TLBool;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesReadEncryptedHistory
extends TLMethod<TLBool> {
    public static final int CONSTRUCTOR_ID = 2135648522;
    protected TLInputEncryptedChat peer;
    protected int maxDate;
    private final String _constructor = "messages.readEncryptedHistory#7f4b690a";

    public TLRequestMessagesReadEncryptedHistory() {
    }

    public TLRequestMessagesReadEncryptedHistory(TLInputEncryptedChat peer, int maxDate) {
        this.peer = peer;
        this.maxDate = maxDate;
    }

    @Override
    public TLBool deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLBool)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLBool)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeInt(this.maxDate, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.peer = StreamUtils.readTLObject(stream, context, TLInputEncryptedChat.class, -247351839);
        this.maxDate = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.peer.computeSerializedSize();
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "messages.readEncryptedHistory#7f4b690a";
    }

    @Override
    public int getConstructorId() {
        return 2135648522;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesReadEncryptedHistory)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesReadEncryptedHistory o = (TLRequestMessagesReadEncryptedHistory)object;
        return (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && this.maxDate == o.maxDate;
    }

    public TLInputEncryptedChat getPeer() {
        return this.peer;
    }

    public void setPeer(TLInputEncryptedChat peer) {
        this.peer = peer;
    }

    public int getMaxDate() {
        return this.maxDate;
    }

    public void setMaxDate(int maxDate) {
        this.maxDate = maxDate;
    }
}

