/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsDocument;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesGetDocumentByHash
extends TLMethod<TLAbsDocument> {
    public static final int CONSTRUCTOR_ID = 864953444;
    protected TLBytes sha256;
    protected int size;
    protected String mimeType;
    private final String _constructor = "messages.getDocumentByHash#338e2464";

    public TLRequestMessagesGetDocumentByHash() {
    }

    public TLRequestMessagesGetDocumentByHash(TLBytes sha256, int size, String mimeType) {
        this.sha256 = sha256;
        this.size = size;
        this.mimeType = mimeType;
    }

    @Override
    public TLAbsDocument deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsDocument)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsDocument)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLBytes(this.sha256, stream);
        StreamUtils.writeInt(this.size, stream);
        StreamUtils.writeString(this.mimeType, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.sha256 = StreamUtils.readTLBytes(stream, context);
        this.size = StreamUtils.readInt(stream);
        this.mimeType = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.computeTLBytesSerializedSize(this.sha256);
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLStringSerializedSize(this.mimeType);
    }

    public String toString() {
        return "messages.getDocumentByHash#338e2464";
    }

    @Override
    public int getConstructorId() {
        return 864953444;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesGetDocumentByHash)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesGetDocumentByHash o = (TLRequestMessagesGetDocumentByHash)object;
        return (this.sha256 == o.sha256 || this.sha256 != null && o.sha256 != null && this.sha256.equals(o.sha256)) && this.size == o.size && (this.mimeType == o.mimeType || this.mimeType != null && o.mimeType != null && this.mimeType.equals(o.mimeType));
    }

    public TLBytes getSha256() {
        return this.sha256;
    }

    public void setSha256(TLBytes sha256) {
        this.sha256 = sha256;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

