/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.core.TLIntVector;
import com.github.badoualy.telegram.tl.core.TLLongVector;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesForwardMessages
extends TLMethod<TLAbsUpdates> {
    public static final int CONSTRUCTOR_ID = 1888354709;
    protected int flags;
    protected boolean broadcast;
    protected TLAbsInputPeer fromPeer;
    protected TLIntVector id;
    protected TLLongVector randomId;
    protected TLAbsInputPeer toPeer;
    private final String _constructor = "messages.forwardMessages#708e0195";

    public TLRequestMessagesForwardMessages() {
    }

    public TLRequestMessagesForwardMessages(boolean broadcast, TLAbsInputPeer fromPeer, TLIntVector id, TLLongVector randomId, TLAbsInputPeer toPeer) {
        this.broadcast = broadcast;
        this.fromPeer = fromPeer;
        this.id = id;
        this.randomId = randomId;
        this.toPeer = toPeer;
    }

    @Override
    public TLAbsUpdates deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsUpdates)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsUpdates)response;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.broadcast ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeTLObject(this.fromPeer, stream);
        StreamUtils.writeTLVector(this.id, stream);
        StreamUtils.writeTLVector(this.randomId, stream);
        StreamUtils.writeTLObject(this.toPeer, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.broadcast = (this.flags & 0x10) != 0;
        this.fromPeer = StreamUtils.readTLObject(stream, context, TLAbsInputPeer.class, -1);
        this.id = StreamUtils.readTLIntVector(stream, context);
        this.randomId = StreamUtils.readTLLongVector(stream, context);
        this.toPeer = StreamUtils.readTLObject(stream, context, TLAbsInputPeer.class, -1);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += this.fromPeer.computeSerializedSize();
        size += this.id.computeSerializedSize();
        size += this.randomId.computeSerializedSize();
        return size += this.toPeer.computeSerializedSize();
    }

    public String toString() {
        return "messages.forwardMessages#708e0195";
    }

    @Override
    public int getConstructorId() {
        return 1888354709;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesForwardMessages)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesForwardMessages o = (TLRequestMessagesForwardMessages)object;
        return this.flags == o.flags && this.broadcast == o.broadcast && (this.fromPeer == o.fromPeer || this.fromPeer != null && o.fromPeer != null && this.fromPeer.equals(o.fromPeer)) && (this.id == o.id || this.id != null && o.id != null && this.id.equals(o.id)) && (this.randomId == o.randomId || this.randomId != null && o.randomId != null && this.randomId.equals(o.randomId)) && (this.toPeer == o.toPeer || this.toPeer != null && o.toPeer != null && this.toPeer.equals(o.toPeer));
    }

    public boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public TLAbsInputPeer getFromPeer() {
        return this.fromPeer;
    }

    public void setFromPeer(TLAbsInputPeer fromPeer) {
        this.fromPeer = fromPeer;
    }

    public TLIntVector getId() {
        return this.id;
    }

    public void setId(TLIntVector id) {
        this.id = id;
    }

    public TLLongVector getRandomId() {
        return this.randomId;
    }

    public void setRandomId(TLLongVector randomId) {
        this.randomId = randomId;
    }

    public TLAbsInputPeer getToPeer() {
        return this.toPeer;
    }

    public void setToPeer(TLAbsInputPeer toPeer) {
        this.toPeer = toPeer;
    }
}

