/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesForwardMessage
extends TLMethod<TLAbsUpdates> {
    public static final int CONSTRUCTOR_ID = 865483769;
    protected TLAbsInputPeer peer;
    protected int id;
    protected long randomId;
    private final String _constructor = "messages.forwardMessage#33963bf9";

    public TLRequestMessagesForwardMessage() {
    }

    public TLRequestMessagesForwardMessage(TLAbsInputPeer peer, int id, long randomId) {
        this.peer = peer;
        this.id = id;
        this.randomId = randomId;
    }

    @Override
    public TLAbsUpdates deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsUpdates)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsUpdates)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeLong(this.randomId, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.peer = StreamUtils.readTLObject(stream, context, TLAbsInputPeer.class, -1);
        this.id = StreamUtils.readInt(stream);
        this.randomId = StreamUtils.readLong(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.peer.computeSerializedSize();
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.SIZE_INT64;
    }

    public String toString() {
        return "messages.forwardMessage#33963bf9";
    }

    @Override
    public int getConstructorId() {
        return 865483769;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesForwardMessage)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesForwardMessage o = (TLRequestMessagesForwardMessage)object;
        return (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && this.id == o.id && this.randomId == o.randomId;
    }

    public TLAbsInputPeer getPeer() {
        return this.peer;
    }

    public void setPeer(TLAbsInputPeer peer) {
        this.peer = peer;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public void setRandomId(long randomId) {
        this.randomId = randomId;
    }
}

