/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsEncryptedChat;
import com.github.badoualy.telegram.tl.api.TLInputEncryptedChat;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestMessagesAcceptEncryption
extends TLMethod<TLAbsEncryptedChat> {
    public static final int CONSTRUCTOR_ID = 1035731989;
    protected TLInputEncryptedChat peer;
    protected TLBytes gB;
    protected long keyFingerprint;
    private final String _constructor = "messages.acceptEncryption#3dbc0415";

    public TLRequestMessagesAcceptEncryption() {
    }

    public TLRequestMessagesAcceptEncryption(TLInputEncryptedChat peer, TLBytes gB, long keyFingerprint) {
        this.peer = peer;
        this.gB = gB;
        this.keyFingerprint = keyFingerprint;
    }

    @Override
    public TLAbsEncryptedChat deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsEncryptedChat)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsEncryptedChat)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLObject(this.peer, stream);
        StreamUtils.writeTLBytes(this.gB, stream);
        StreamUtils.writeLong(this.keyFingerprint, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.peer = StreamUtils.readTLObject(stream, context, TLInputEncryptedChat.class, -247351839);
        this.gB = StreamUtils.readTLBytes(stream, context);
        this.keyFingerprint = StreamUtils.readLong(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += this.peer.computeSerializedSize();
        size += TLObjectUtils.computeTLBytesSerializedSize(this.gB);
        return size += TLObjectUtils.SIZE_INT64;
    }

    public String toString() {
        return "messages.acceptEncryption#3dbc0415";
    }

    @Override
    public int getConstructorId() {
        return 1035731989;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestMessagesAcceptEncryption)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestMessagesAcceptEncryption o = (TLRequestMessagesAcceptEncryption)object;
        return (this.peer == o.peer || this.peer != null && o.peer != null && this.peer.equals(o.peer)) && (this.gB == o.gB || this.gB != null && o.gB != null && this.gB.equals(o.gB)) && this.keyFingerprint == o.keyFingerprint;
    }

    public TLInputEncryptedChat getPeer() {
        return this.peer;
    }

    public void setPeer(TLInputEncryptedChat peer) {
        this.peer = peer;
    }

    public TLBytes getGB() {
        return this.gB;
    }

    public void setGB(TLBytes gB) {
        this.gB = gB;
    }

    public long getKeyFingerprint() {
        return this.keyFingerprint;
    }

    public void setKeyFingerprint(long keyFingerprint) {
        this.keyFingerprint = keyFingerprint;
    }
}

