/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestInvokeWithLayer<T extends TLObject>
extends TLMethod<T> {
    public static final int CONSTRUCTOR_ID = -627372787;
    protected int layer;
    protected TLMethod<T> query;
    private final String _constructor = "invokeWithLayer#da9b0d0d";

    public TLRequestInvokeWithLayer() {
    }

    public TLRequestInvokeWithLayer(int layer, TLMethod<T> query) {
        this.layer = layer;
        this.query = query;
    }

    @Override
    public T deserializeResponse(InputStream stream, TLContext context) throws IOException {
        return this.query.deserializeResponse(stream, context);
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.layer, stream);
        StreamUtils.writeTLMethod(this.query, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.layer = StreamUtils.readInt(stream);
        this.query = StreamUtils.readTLMethod(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += this.query.computeSerializedSize();
    }

    public String toString() {
        return "invokeWithLayer#da9b0d0d";
    }

    @Override
    public int getConstructorId() {
        return -627372787;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestInvokeWithLayer)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestInvokeWithLayer o = (TLRequestInvokeWithLayer)object;
        return this.layer == o.layer && (this.query == o.query || this.query != null && o.query != null && this.query.equals(o.query));
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public TLMethod<T> getQuery() {
        return this.query;
    }

    public void setQuery(TLMethod<T> query) {
        this.query = query;
    }
}

