/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestInvokeAfterMsg<T extends TLObject>
extends TLMethod<T> {
    public static final int CONSTRUCTOR_ID = -878758099;
    protected long msgId;
    protected TLMethod<T> query;
    private final String _constructor = "invokeAfterMsg#cb9f372d";

    public TLRequestInvokeAfterMsg() {
    }

    public TLRequestInvokeAfterMsg(long msgId, TLMethod<T> query) {
        this.msgId = msgId;
        this.query = query;
    }

    @Override
    public T deserializeResponse(InputStream stream, TLContext context) throws IOException {
        return this.query.deserializeResponse(stream, context);
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.msgId, stream);
        StreamUtils.writeTLMethod(this.query, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.msgId = StreamUtils.readLong(stream);
        this.query = StreamUtils.readTLMethod(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        return size += this.query.computeSerializedSize();
    }

    public String toString() {
        return "invokeAfterMsg#cb9f372d";
    }

    @Override
    public int getConstructorId() {
        return -878758099;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestInvokeAfterMsg)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestInvokeAfterMsg o = (TLRequestInvokeAfterMsg)object;
        return this.msgId == o.msgId && (this.query == o.query || this.query != null && o.query != null && this.query.equals(o.query));
    }

    public long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    public TLMethod<T> getQuery() {
        return this.query;
    }

    public void setQuery(TLMethod<T> query) {
        this.query = query;
    }
}

