/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestInitConnection<T extends TLObject>
extends TLMethod<T> {
    public static final int CONSTRUCTOR_ID = 1769565673;
    protected int apiId;
    protected String deviceModel;
    protected String systemVersion;
    protected String appVersion;
    protected String langCode;
    protected TLMethod<T> query;
    private final String _constructor = "initConnection#69796de9";

    public TLRequestInitConnection() {
    }

    public TLRequestInitConnection(int apiId, String deviceModel, String systemVersion, String appVersion, String langCode, TLMethod<T> query) {
        this.apiId = apiId;
        this.deviceModel = deviceModel;
        this.systemVersion = systemVersion;
        this.appVersion = appVersion;
        this.langCode = langCode;
        this.query = query;
    }

    @Override
    public T deserializeResponse(InputStream stream, TLContext context) throws IOException {
        return this.query.deserializeResponse(stream, context);
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.apiId, stream);
        StreamUtils.writeString(this.deviceModel, stream);
        StreamUtils.writeString(this.systemVersion, stream);
        StreamUtils.writeString(this.appVersion, stream);
        StreamUtils.writeString(this.langCode, stream);
        StreamUtils.writeTLMethod(this.query, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.apiId = StreamUtils.readInt(stream);
        this.deviceModel = StreamUtils.readTLString(stream);
        this.systemVersion = StreamUtils.readTLString(stream);
        this.appVersion = StreamUtils.readTLString(stream);
        this.langCode = StreamUtils.readTLString(stream);
        this.query = StreamUtils.readTLMethod(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.deviceModel);
        size += TLObjectUtils.computeTLStringSerializedSize(this.systemVersion);
        size += TLObjectUtils.computeTLStringSerializedSize(this.appVersion);
        size += TLObjectUtils.computeTLStringSerializedSize(this.langCode);
        return size += this.query.computeSerializedSize();
    }

    public String toString() {
        return "initConnection#69796de9";
    }

    @Override
    public int getConstructorId() {
        return 1769565673;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestInitConnection)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestInitConnection o = (TLRequestInitConnection)object;
        return this.apiId == o.apiId && (this.deviceModel == o.deviceModel || this.deviceModel != null && o.deviceModel != null && this.deviceModel.equals(o.deviceModel)) && (this.systemVersion == o.systemVersion || this.systemVersion != null && o.systemVersion != null && this.systemVersion.equals(o.systemVersion)) && (this.appVersion == o.appVersion || this.appVersion != null && o.appVersion != null && this.appVersion.equals(o.appVersion)) && (this.langCode == o.langCode || this.langCode != null && o.langCode != null && this.langCode.equals(o.langCode)) && (this.query == o.query || this.query != null && o.query != null && this.query.equals(o.query));
    }

    public int getApiId() {
        return this.apiId;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public void setDeviceModel(String deviceModel) {
        this.deviceModel = deviceModel;
    }

    public String getSystemVersion() {
        return this.systemVersion;
    }

    public void setSystemVersion(String systemVersion) {
        this.systemVersion = systemVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }

    public TLMethod<T> getQuery() {
        return this.query;
    }

    public void setQuery(TLMethod<T> query) {
        this.query = query;
    }
}

