/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.contacts.TLFound;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestContactsSearch
extends TLMethod<TLFound> {
    public static final int CONSTRUCTOR_ID = 301470424;
    protected String q;
    protected int limit;
    private final String _constructor = "contacts.search#11f812d8";

    public TLRequestContactsSearch() {
    }

    public TLRequestContactsSearch(String q, int limit) {
        this.q = q;
        this.limit = limit;
    }

    @Override
    public TLFound deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLFound)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLFound)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeString(this.q, stream);
        StreamUtils.writeInt(this.limit, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.q = StreamUtils.readTLString(stream);
        this.limit = StreamUtils.readInt(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.computeTLStringSerializedSize(this.q);
        return size += TLObjectUtils.SIZE_INT32;
    }

    public String toString() {
        return "contacts.search#11f812d8";
    }

    @Override
    public int getConstructorId() {
        return 301470424;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestContactsSearch)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestContactsSearch o = (TLRequestContactsSearch)object;
        return (this.q == o.q || this.q != null && o.q != null && this.q.equals(o.q)) && this.limit == o.limit;
    }

    public String getQ() {
        return this.q;
    }

    public void setQ(String q) {
        this.q = q;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }
}

