/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestChannelsCreateChannel
extends TLMethod<TLAbsUpdates> {
    public static final int CONSTRUCTOR_ID = -192332417;
    protected int flags;
    protected boolean broadcast;
    protected boolean megagroup;
    protected String title;
    protected String about;
    private final String _constructor = "channels.createChannel#f4893d7f";

    public TLRequestChannelsCreateChannel() {
    }

    public TLRequestChannelsCreateChannel(boolean broadcast, boolean megagroup, String title, String about) {
        this.broadcast = broadcast;
        this.megagroup = megagroup;
        this.title = title;
        this.about = about;
    }

    @Override
    public TLAbsUpdates deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsUpdates)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsUpdates)response;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.broadcast ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.megagroup ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeString(this.title, stream);
        StreamUtils.writeString(this.about, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.broadcast = (this.flags & 1) != 0;
        this.megagroup = (this.flags & 2) != 0;
        this.title = StreamUtils.readTLString(stream);
        this.about = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.title);
        return size += TLObjectUtils.computeTLStringSerializedSize(this.about);
    }

    public String toString() {
        return "channels.createChannel#f4893d7f";
    }

    @Override
    public int getConstructorId() {
        return -192332417;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestChannelsCreateChannel)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestChannelsCreateChannel o = (TLRequestChannelsCreateChannel)object;
        return this.flags == o.flags && this.broadcast == o.broadcast && this.megagroup == o.megagroup && (this.title == o.title || this.title != null && o.title != null && this.title.equals(o.title)) && (this.about == o.about || this.about != null && o.about != null && this.about.equals(o.about));
    }

    public boolean getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public boolean getMegagroup() {
        return this.megagroup;
    }

    public void setMegagroup(boolean megagroup) {
        this.megagroup = megagroup;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAbout() {
        return this.about;
    }

    public void setAbout(String about) {
        this.about = about;
    }
}

