/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.auth.TLAuthorization;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestAuthSignUp
extends TLMethod<TLAuthorization> {
    public static final int CONSTRUCTOR_ID = 453408308;
    protected String phoneNumber;
    protected String phoneCodeHash;
    protected String phoneCode;
    protected String firstName;
    protected String lastName;
    private final String _constructor = "auth.signUp#1b067634";

    public TLRequestAuthSignUp() {
    }

    public TLRequestAuthSignUp(String phoneNumber, String phoneCodeHash, String phoneCode, String firstName, String lastName) {
        this.phoneNumber = phoneNumber;
        this.phoneCodeHash = phoneCodeHash;
        this.phoneCode = phoneCode;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    @Override
    public TLAuthorization deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAuthorization)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAuthorization)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeString(this.phoneNumber, stream);
        StreamUtils.writeString(this.phoneCodeHash, stream);
        StreamUtils.writeString(this.phoneCode, stream);
        StreamUtils.writeString(this.firstName, stream);
        StreamUtils.writeString(this.lastName, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.phoneNumber = StreamUtils.readTLString(stream);
        this.phoneCodeHash = StreamUtils.readTLString(stream);
        this.phoneCode = StreamUtils.readTLString(stream);
        this.firstName = StreamUtils.readTLString(stream);
        this.lastName = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.computeTLStringSerializedSize(this.phoneNumber);
        size += TLObjectUtils.computeTLStringSerializedSize(this.phoneCodeHash);
        size += TLObjectUtils.computeTLStringSerializedSize(this.phoneCode);
        size += TLObjectUtils.computeTLStringSerializedSize(this.firstName);
        return size += TLObjectUtils.computeTLStringSerializedSize(this.lastName);
    }

    public String toString() {
        return "auth.signUp#1b067634";
    }

    @Override
    public int getConstructorId() {
        return 453408308;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestAuthSignUp)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestAuthSignUp o = (TLRequestAuthSignUp)object;
        return (this.phoneNumber == o.phoneNumber || this.phoneNumber != null && o.phoneNumber != null && this.phoneNumber.equals(o.phoneNumber)) && (this.phoneCodeHash == o.phoneCodeHash || this.phoneCodeHash != null && o.phoneCodeHash != null && this.phoneCodeHash.equals(o.phoneCodeHash)) && (this.phoneCode == o.phoneCode || this.phoneCode != null && o.phoneCode != null && this.phoneCode.equals(o.phoneCode)) && (this.firstName == o.firstName || this.firstName != null && o.firstName != null && this.firstName.equals(o.firstName)) && (this.lastName == o.lastName || this.lastName != null && o.lastName != null && this.lastName.equals(o.lastName));
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getPhoneCodeHash() {
        return this.phoneCodeHash;
    }

    public void setPhoneCodeHash(String phoneCodeHash) {
        this.phoneCodeHash = phoneCodeHash;
    }

    public String getPhoneCode() {
        return this.phoneCode;
    }

    public void setPhoneCode(String phoneCode) {
        this.phoneCode = phoneCode;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
}

