/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.auth.TLAuthorization;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestAuthSignIn
extends TLMethod<TLAuthorization> {
    public static final int CONSTRUCTOR_ID = -1126886015;
    protected String phoneNumber;
    protected String phoneCodeHash;
    protected String phoneCode;
    private final String _constructor = "auth.signIn#bcd51581";

    public TLRequestAuthSignIn() {
    }

    public TLRequestAuthSignIn(String phoneNumber, String phoneCodeHash, String phoneCode) {
        this.phoneNumber = phoneNumber;
        this.phoneCodeHash = phoneCodeHash;
        this.phoneCode = phoneCode;
    }

    @Override
    public TLAuthorization deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAuthorization)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAuthorization)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeString(this.phoneNumber, stream);
        StreamUtils.writeString(this.phoneCodeHash, stream);
        StreamUtils.writeString(this.phoneCode, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.phoneNumber = StreamUtils.readTLString(stream);
        this.phoneCodeHash = StreamUtils.readTLString(stream);
        this.phoneCode = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.computeTLStringSerializedSize(this.phoneNumber);
        size += TLObjectUtils.computeTLStringSerializedSize(this.phoneCodeHash);
        return size += TLObjectUtils.computeTLStringSerializedSize(this.phoneCode);
    }

    public String toString() {
        return "auth.signIn#bcd51581";
    }

    @Override
    public int getConstructorId() {
        return -1126886015;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestAuthSignIn)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestAuthSignIn o = (TLRequestAuthSignIn)object;
        return (this.phoneNumber == o.phoneNumber || this.phoneNumber != null && o.phoneNumber != null && this.phoneNumber.equals(o.phoneNumber)) && (this.phoneCodeHash == o.phoneCodeHash || this.phoneCodeHash != null && o.phoneCodeHash != null && this.phoneCodeHash.equals(o.phoneCodeHash)) && (this.phoneCode == o.phoneCode || this.phoneCode != null && o.phoneCode != null && this.phoneCode.equals(o.phoneCode));
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getPhoneCodeHash() {
        return this.phoneCodeHash;
    }

    public void setPhoneCodeHash(String phoneCodeHash) {
        this.phoneCodeHash = phoneCodeHash;
    }

    public String getPhoneCode() {
        return this.phoneCode;
    }

    public void setPhoneCode(String phoneCode) {
        this.phoneCode = phoneCode;
    }
}

