/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.auth.TLAbsSentCode;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestAuthSendCode
extends TLMethod<TLAbsSentCode> {
    public static final int CONSTRUCTOR_ID = 1988976461;
    protected String phoneNumber;
    protected int smsType;
    protected int apiId;
    protected String apiHash;
    protected String langCode;
    private final String _constructor = "auth.sendCode#768d5f4d";

    public TLRequestAuthSendCode() {
    }

    public TLRequestAuthSendCode(String phoneNumber, int smsType, int apiId, String apiHash, String langCode) {
        this.phoneNumber = phoneNumber;
        this.smsType = smsType;
        this.apiId = apiId;
        this.apiHash = apiHash;
        this.langCode = langCode;
    }

    @Override
    public TLAbsSentCode deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAbsSentCode)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAbsSentCode)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeString(this.phoneNumber, stream);
        StreamUtils.writeInt(this.smsType, stream);
        StreamUtils.writeInt(this.apiId, stream);
        StreamUtils.writeString(this.apiHash, stream);
        StreamUtils.writeString(this.langCode, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.phoneNumber = StreamUtils.readTLString(stream);
        this.smsType = StreamUtils.readInt(stream);
        this.apiId = StreamUtils.readInt(stream);
        this.apiHash = StreamUtils.readTLString(stream);
        this.langCode = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.computeTLStringSerializedSize(this.phoneNumber);
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLStringSerializedSize(this.apiHash);
        return size += TLObjectUtils.computeTLStringSerializedSize(this.langCode);
    }

    public String toString() {
        return "auth.sendCode#768d5f4d";
    }

    @Override
    public int getConstructorId() {
        return 1988976461;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestAuthSendCode)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestAuthSendCode o = (TLRequestAuthSendCode)object;
        return (this.phoneNumber == o.phoneNumber || this.phoneNumber != null && o.phoneNumber != null && this.phoneNumber.equals(o.phoneNumber)) && this.smsType == o.smsType && this.apiId == o.apiId && (this.apiHash == o.apiHash || this.apiHash != null && o.apiHash != null && this.apiHash.equals(o.apiHash)) && (this.langCode == o.langCode || this.langCode != null && o.langCode != null && this.langCode.equals(o.langCode));
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public int getSmsType() {
        return this.smsType;
    }

    public void setSmsType(int smsType) {
        this.smsType = smsType;
    }

    public int getApiId() {
        return this.apiId;
    }

    public void setApiId(int apiId) {
        this.apiId = apiId;
    }

    public String getApiHash() {
        return this.apiHash;
    }

    public void setApiHash(String apiHash) {
        this.apiHash = apiHash;
    }

    public String getLangCode() {
        return this.langCode;
    }

    public void setLangCode(String langCode) {
        this.langCode = langCode;
    }
}

