/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.auth.TLAuthorization;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestAuthImportAuthorization
extends TLMethod<TLAuthorization> {
    public static final int CONSTRUCTOR_ID = -470837741;
    protected int id;
    protected TLBytes bytes;
    private final String _constructor = "auth.importAuthorization#e3ef9613";

    public TLRequestAuthImportAuthorization() {
    }

    public TLRequestAuthImportAuthorization(int id, TLBytes bytes) {
        this.id = id;
        this.bytes = bytes;
    }

    @Override
    public TLAuthorization deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAuthorization)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAuthorization)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeTLBytes(this.bytes, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readInt(stream);
        this.bytes = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.bytes);
    }

    public String toString() {
        return "auth.importAuthorization#e3ef9613";
    }

    @Override
    public int getConstructorId() {
        return -470837741;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestAuthImportAuthorization)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestAuthImportAuthorization o = (TLRequestAuthImportAuthorization)object;
        return this.id == o.id && (this.bytes == o.bytes || this.bytes != null && o.bytes != null && this.bytes.equals(o.bytes));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public TLBytes getBytes() {
        return this.bytes;
    }

    public void setBytes(TLBytes bytes) {
        this.bytes = bytes;
    }
}

