/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.auth.TLCheckedPhone;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestAuthCheckPhone
extends TLMethod<TLCheckedPhone> {
    public static final int CONSTRUCTOR_ID = 1877286395;
    protected String phoneNumber;
    private final String _constructor = "auth.checkPhone#6fe51dfb";

    public TLRequestAuthCheckPhone() {
    }

    public TLRequestAuthCheckPhone(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Override
    public TLCheckedPhone deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLCheckedPhone)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLCheckedPhone)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeString(this.phoneNumber, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.phoneNumber = StreamUtils.readTLString(stream);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        return size += TLObjectUtils.computeTLStringSerializedSize(this.phoneNumber);
    }

    public String toString() {
        return "auth.checkPhone#6fe51dfb";
    }

    @Override
    public int getConstructorId() {
        return 1877286395;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestAuthCheckPhone)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestAuthCheckPhone o = (TLRequestAuthCheckPhone)object;
        return this.phoneNumber == o.phoneNumber || this.phoneNumber != null && o.phoneNumber != null && this.phoneNumber.equals(o.phoneNumber);
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }
}

