/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.auth.TLAuthorization;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestAuthCheckPassword
extends TLMethod<TLAuthorization> {
    public static final int CONSTRUCTOR_ID = 174260510;
    protected TLBytes passwordHash;
    private final String _constructor = "auth.checkPassword#a63011e";

    public TLRequestAuthCheckPassword() {
    }

    public TLRequestAuthCheckPassword(TLBytes passwordHash) {
        this.passwordHash = passwordHash;
    }

    @Override
    public TLAuthorization deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLAuthorization)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLAuthorization)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeTLBytes(this.passwordHash, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.passwordHash = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.passwordHash);
    }

    public String toString() {
        return "auth.checkPassword#a63011e";
    }

    @Override
    public int getConstructorId() {
        return 174260510;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestAuthCheckPassword)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestAuthCheckPassword o = (TLRequestAuthCheckPassword)object;
        return this.passwordHash == o.passwordHash || this.passwordHash != null && o.passwordHash != null && this.passwordHash.equals(o.passwordHash);
    }

    public TLBytes getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(TLBytes passwordHash) {
        this.passwordHash = passwordHash;
    }
}

