/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.request;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLBool;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLRequestAuthBindTempAuthKey
extends TLMethod<TLBool> {
    public static final int CONSTRUCTOR_ID = -841733627;
    protected long permAuthKeyId;
    protected long nonce;
    protected int expiresAt;
    protected TLBytes encryptedMessage;
    private final String _constructor = "auth.bindTempAuthKey#cdd42a05";

    public TLRequestAuthBindTempAuthKey() {
    }

    public TLRequestAuthBindTempAuthKey(long permAuthKeyId, long nonce, int expiresAt, TLBytes encryptedMessage) {
        this.permAuthKeyId = permAuthKeyId;
        this.nonce = nonce;
        this.expiresAt = expiresAt;
        this.encryptedMessage = encryptedMessage;
    }

    @Override
    public TLBool deserializeResponse(InputStream stream, TLContext context) throws IOException {
        TLObject response = StreamUtils.readTLObject(stream, context);
        if (response == null) {
            throw new IOException("Unable to parse response");
        }
        if (!(response instanceof TLBool)) {
            throw new IOException("Incorrect response type, expected getClass().getCanonicalName(), found response.getClass().getCanonicalName()");
        }
        return (TLBool)response;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeLong(this.permAuthKeyId, stream);
        StreamUtils.writeLong(this.nonce, stream);
        StreamUtils.writeInt(this.expiresAt, stream);
        StreamUtils.writeTLBytes(this.encryptedMessage, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.permAuthKeyId = StreamUtils.readLong(stream);
        this.nonce = StreamUtils.readLong(stream);
        this.expiresAt = StreamUtils.readInt(stream);
        this.encryptedMessage = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT64;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.encryptedMessage);
    }

    public String toString() {
        return "auth.bindTempAuthKey#cdd42a05";
    }

    @Override
    public int getConstructorId() {
        return -841733627;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLRequestAuthBindTempAuthKey)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLRequestAuthBindTempAuthKey o = (TLRequestAuthBindTempAuthKey)object;
        return this.permAuthKeyId == o.permAuthKeyId && this.nonce == o.nonce && this.expiresAt == o.expiresAt && (this.encryptedMessage == o.encryptedMessage || this.encryptedMessage != null && o.encryptedMessage != null && this.encryptedMessage.equals(o.encryptedMessage));
    }

    public long getPermAuthKeyId() {
        return this.permAuthKeyId;
    }

    public void setPermAuthKeyId(long permAuthKeyId) {
        this.permAuthKeyId = permAuthKeyId;
    }

    public long getNonce() {
        return this.nonce;
    }

    public void setNonce(long nonce) {
        this.nonce = nonce;
    }

    public int getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(int expiresAt) {
        this.expiresAt = expiresAt;
    }

    public TLBytes getEncryptedMessage() {
        return this.encryptedMessage;
    }

    public void setEncryptedMessage(TLBytes encryptedMessage) {
        this.encryptedMessage = encryptedMessage;
    }
}

