/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.messages;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsDocument;
import com.github.badoualy.telegram.tl.api.messages.TLAbsStickers;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLStickers
extends TLAbsStickers {
    public static final int CONSTRUCTOR_ID = -1970352846;
    protected String hash;
    protected TLVector<TLAbsDocument> stickers;
    private final String _constructor = "messages.stickers#8a8ecd32";

    public TLStickers() {
    }

    public TLStickers(String hash, TLVector<TLAbsDocument> stickers) {
        this.hash = hash;
        this.stickers = stickers;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeString(this.hash, stream);
        StreamUtils.writeTLVector(this.stickers, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.hash = StreamUtils.readTLString(stream);
        this.stickers = StreamUtils.readTLVector(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.computeTLStringSerializedSize(this.hash);
        return size += this.stickers.computeSerializedSize();
    }

    public String toString() {
        return "messages.stickers#8a8ecd32";
    }

    @Override
    public int getConstructorId() {
        return -1970352846;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLStickers)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLStickers o = (TLStickers)object;
        return (this.hash == o.hash || this.hash != null && o.hash != null && this.hash.equals(o.hash)) && (this.stickers == o.stickers || this.stickers != null && o.stickers != null && this.stickers.equals(o.stickers));
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public TLVector<TLAbsDocument> getStickers() {
        return this.stickers;
    }

    public void setStickers(TLVector<TLAbsDocument> stickers) {
        this.stickers = stickers;
    }
}

