/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.messages;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsEncryptedFile;
import com.github.badoualy.telegram.tl.api.messages.TLAbsSentEncryptedMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLSentEncryptedFile
extends TLAbsSentEncryptedMessage {
    public static final int CONSTRUCTOR_ID = -1802240206;
    protected TLAbsEncryptedFile file;
    private final String _constructor = "messages.sentEncryptedFile#9493ff32";

    public TLSentEncryptedFile() {
    }

    public TLSentEncryptedFile(int date, TLAbsEncryptedFile file) {
        this.date = date;
        this.file = file;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.date, stream);
        StreamUtils.writeTLObject(this.file, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.date = StreamUtils.readInt(stream);
        this.file = StreamUtils.readTLObject(stream, context, TLAbsEncryptedFile.class, -1);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += this.file.computeSerializedSize();
    }

    public String toString() {
        return "messages.sentEncryptedFile#9493ff32";
    }

    @Override
    public int getConstructorId() {
        return -1802240206;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLSentEncryptedFile)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLSentEncryptedFile o = (TLSentEncryptedFile)object;
        return this.date == o.date && (this.file == o.file || this.file != null && o.file != null && this.file.equals(o.file));
    }

    @Override
    public int getDate() {
        return this.date;
    }

    @Override
    public void setDate(int date) {
        this.date = date;
    }

    public TLAbsEncryptedFile getFile() {
        return this.file;
    }

    public void setFile(TLAbsEncryptedFile file) {
        this.file = file;
    }
}

