/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.messages;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.messages.TLAbsDhConfig;
import com.github.badoualy.telegram.tl.core.TLBytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLDhConfig
extends TLAbsDhConfig {
    public static final int CONSTRUCTOR_ID = 740433629;
    protected int g;
    protected TLBytes p;
    protected int version;
    private final String _constructor = "messages.dhConfig#2c221edd";

    public TLDhConfig() {
    }

    public TLDhConfig(int g, TLBytes p, int version, TLBytes random) {
        this.g = g;
        this.p = p;
        this.version = version;
        this.random = random;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.g, stream);
        StreamUtils.writeTLBytes(this.p, stream);
        StreamUtils.writeInt(this.version, stream);
        StreamUtils.writeTLBytes(this.random, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.g = StreamUtils.readInt(stream);
        this.p = StreamUtils.readTLBytes(stream, context);
        this.version = StreamUtils.readInt(stream);
        this.random = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.computeTLBytesSerializedSize(this.p);
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.random);
    }

    public String toString() {
        return "messages.dhConfig#2c221edd";
    }

    @Override
    public int getConstructorId() {
        return 740433629;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLDhConfig)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLDhConfig o = (TLDhConfig)object;
        return this.g == o.g && (this.p == o.p || this.p != null && o.p != null && this.p.equals(o.p)) && this.version == o.version && (this.random == o.random || this.random != null && o.random != null && this.random.equals(o.random));
    }

    public int getG() {
        return this.g;
    }

    public void setG(int g) {
        this.g = g;
    }

    public TLBytes getP() {
        return this.p;
    }

    public void setP(TLBytes p) {
        this.p = p;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public TLBytes getRandom() {
        return this.random;
    }

    @Override
    public void setRandom(TLBytes random) {
        this.random = random;
    }
}

