/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.messages;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsChat;
import com.github.badoualy.telegram.tl.api.TLAbsMessage;
import com.github.badoualy.telegram.tl.api.TLAbsUser;
import com.github.badoualy.telegram.tl.api.TLMessageGroup;
import com.github.badoualy.telegram.tl.api.messages.TLAbsMessages;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLChannelMessages
extends TLAbsMessages {
    public static final int CONSTRUCTOR_ID = -1139861572;
    protected int flags;
    protected int pts;
    protected int count;
    protected TLVector<TLMessageGroup> collapsed;
    private final String _constructor = "messages.channelMessages#bc0f17bc";

    public TLChannelMessages() {
    }

    public TLChannelMessages(int pts, int count, TLVector<TLAbsMessage> messages, TLVector<TLMessageGroup> collapsed, TLVector<TLAbsChat> chats, TLVector<TLAbsUser> users) {
        this.pts = pts;
        this.count = count;
        this.messages = messages;
        this.collapsed = collapsed;
        this.chats = chats;
        this.users = users;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.collapsed != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeInt(this.pts, stream);
        StreamUtils.writeInt(this.count, stream);
        StreamUtils.writeTLVector(this.messages, stream);
        if ((this.flags & 1) != 0) {
            StreamUtils.writeTLVector(this.collapsed, stream);
        }
        StreamUtils.writeTLVector(this.chats, stream);
        StreamUtils.writeTLVector(this.users, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.pts = StreamUtils.readInt(stream);
        this.count = StreamUtils.readInt(stream);
        this.messages = StreamUtils.readTLVector(stream, context);
        this.collapsed = (this.flags & 1) != 0 ? StreamUtils.readTLVector(stream, context) : null;
        this.chats = StreamUtils.readTLVector(stream, context);
        this.users = StreamUtils.readTLVector(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT32;
        size += this.messages.computeSerializedSize();
        if ((this.flags & 1) != 0) {
            size += this.collapsed.computeSerializedSize();
        }
        size += this.chats.computeSerializedSize();
        return size += this.users.computeSerializedSize();
    }

    public String toString() {
        return "messages.channelMessages#bc0f17bc";
    }

    @Override
    public int getConstructorId() {
        return -1139861572;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLChannelMessages)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLChannelMessages o = (TLChannelMessages)object;
        return this.flags == o.flags && this.pts == o.pts && this.count == o.count && (this.messages == o.messages || this.messages != null && o.messages != null && this.messages.equals(o.messages)) && (this.collapsed == o.collapsed || this.collapsed != null && o.collapsed != null && this.collapsed.equals(o.collapsed)) && (this.chats == o.chats || this.chats != null && o.chats != null && this.chats.equals(o.chats)) && (this.users == o.users || this.users != null && o.users != null && this.users.equals(o.users));
    }

    public int getPts() {
        return this.pts;
    }

    public void setPts(int pts) {
        this.pts = pts;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public TLVector<TLAbsMessage> getMessages() {
        return this.messages;
    }

    @Override
    public void setMessages(TLVector<TLAbsMessage> messages) {
        this.messages = messages;
    }

    public TLVector<TLMessageGroup> getCollapsed() {
        return this.collapsed;
    }

    public void setCollapsed(TLVector<TLMessageGroup> collapsed) {
        this.collapsed = collapsed;
    }

    @Override
    public TLVector<TLAbsChat> getChats() {
        return this.chats;
    }

    @Override
    public void setChats(TLVector<TLAbsChat> chats) {
        this.chats = chats;
    }

    @Override
    public TLVector<TLAbsUser> getUsers() {
        return this.users;
    }

    @Override
    public void setUsers(TLVector<TLAbsUser> users) {
        this.users = users;
    }
}

