/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.messages;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.api.TLAbsBotInlineResult;
import com.github.badoualy.telegram.tl.core.TLObject;
import com.github.badoualy.telegram.tl.core.TLVector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLBotResults
extends TLObject {
    public static final int CONSTRUCTOR_ID = 292597923;
    protected int flags;
    protected boolean gallery;
    protected long queryId;
    protected String nextOffset;
    protected TLVector<TLAbsBotInlineResult> results;
    private final String _constructor = "messages.botResults#1170b0a3";

    public TLBotResults() {
    }

    public TLBotResults(boolean gallery, long queryId, String nextOffset, TLVector<TLAbsBotInlineResult> results) {
        this.gallery = gallery;
        this.queryId = queryId;
        this.nextOffset = nextOffset;
        this.results = results;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.gallery ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.nextOffset != null ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        StreamUtils.writeLong(this.queryId, stream);
        if ((this.flags & 2) != 0) {
            StreamUtils.writeString(this.nextOffset, stream);
        }
        StreamUtils.writeTLVector(this.results, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.gallery = (this.flags & 1) != 0;
        this.queryId = StreamUtils.readLong(stream);
        this.nextOffset = (this.flags & 2) != 0 ? StreamUtils.readTLString(stream) : null;
        this.results = StreamUtils.readTLVector(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        size += TLObjectUtils.SIZE_INT64;
        if ((this.flags & 2) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.nextOffset);
        }
        return size += this.results.computeSerializedSize();
    }

    public String toString() {
        return "messages.botResults#1170b0a3";
    }

    @Override
    public int getConstructorId() {
        return 292597923;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLBotResults)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLBotResults o = (TLBotResults)object;
        return this.flags == o.flags && this.gallery == o.gallery && this.queryId == o.queryId && (this.nextOffset == o.nextOffset || this.nextOffset != null && o.nextOffset != null && this.nextOffset.equals(o.nextOffset)) && (this.results == o.results || this.results != null && o.results != null && this.results.equals(o.results));
    }

    public boolean getGallery() {
        return this.gallery;
    }

    public void setGallery(boolean gallery) {
        this.gallery = gallery;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public void setQueryId(long queryId) {
        this.queryId = queryId;
    }

    public String getNextOffset() {
        return this.nextOffset;
    }

    public void setNextOffset(String nextOffset) {
        this.nextOffset = nextOffset;
    }

    public TLVector<TLAbsBotInlineResult> getResults() {
        return this.results;
    }

    public void setResults(TLVector<TLAbsBotInlineResult> results) {
        this.results = results;
    }
}

