/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.auth;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLExportedAuthorization
extends TLObject {
    public static final int CONSTRUCTOR_ID = -543777747;
    protected int id;
    protected TLBytes bytes;
    private final String _constructor = "auth.exportedAuthorization#df969c2d";

    public TLExportedAuthorization() {
    }

    public TLExportedAuthorization(int id, TLBytes bytes) {
        this.id = id;
        this.bytes = bytes;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamUtils.writeInt(this.id, stream);
        StreamUtils.writeTLBytes(this.bytes, stream);
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.id = StreamUtils.readInt(stream);
        this.bytes = StreamUtils.readTLBytes(stream, context);
    }

    @Override
    public int computeSerializedSize() {
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        return size += TLObjectUtils.computeTLBytesSerializedSize(this.bytes);
    }

    public String toString() {
        return "auth.exportedAuthorization#df969c2d";
    }

    @Override
    public int getConstructorId() {
        return -543777747;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLExportedAuthorization)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLExportedAuthorization o = (TLExportedAuthorization)object;
        return this.id == o.id && (this.bytes == o.bytes || this.bytes != null && o.bytes != null && this.bytes.equals(o.bytes));
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public TLBytes getBytes() {
        return this.bytes;
    }

    public void setBytes(TLBytes bytes) {
        this.bytes = bytes;
    }
}

