/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.tl.api.account;

import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TLPasswordInputSettings
extends TLObject {
    public static final int CONSTRUCTOR_ID = -1124314324;
    protected int flags;
    protected TLBytes newSalt;
    protected TLBytes newPasswordHash;
    protected String hint;
    protected String email;
    private final String _constructor = "account.passwordInputSettings#bcfc532c";

    public TLPasswordInputSettings() {
    }

    public TLPasswordInputSettings(TLBytes newSalt, TLBytes newPasswordHash, String hint, String email) {
        this.newSalt = newSalt;
        this.newPasswordHash = newPasswordHash;
        this.hint = hint;
        this.email = email;
    }

    private void computeFlags() {
        this.flags = 0;
        this.flags = this.newSalt != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.newPasswordHash != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.hint != null ? this.flags | 1 : this.flags & 0xFFFFFFFE;
        this.flags = this.email != null ? this.flags | 2 : this.flags & 0xFFFFFFFD;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        this.computeFlags();
        StreamUtils.writeInt(this.flags, stream);
        if ((this.flags & 1) != 0) {
            StreamUtils.writeTLBytes(this.newSalt, stream);
        }
        if ((this.flags & 1) != 0) {
            StreamUtils.writeTLBytes(this.newPasswordHash, stream);
        }
        if ((this.flags & 1) != 0) {
            StreamUtils.writeString(this.hint, stream);
        }
        if ((this.flags & 2) != 0) {
            StreamUtils.writeString(this.email, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamUtils.readInt(stream);
        this.newSalt = (this.flags & 1) != 0 ? StreamUtils.readTLBytes(stream, context) : null;
        this.newPasswordHash = (this.flags & 1) != 0 ? StreamUtils.readTLBytes(stream, context) : null;
        this.hint = (this.flags & 1) != 0 ? StreamUtils.readTLString(stream) : null;
        this.email = (this.flags & 2) != 0 ? StreamUtils.readTLString(stream) : null;
    }

    @Override
    public int computeSerializedSize() {
        this.computeFlags();
        int size = TLObjectUtils.SIZE_CONSTRUCTOR_ID;
        size += TLObjectUtils.SIZE_INT32;
        if ((this.flags & 1) != 0) {
            size += TLObjectUtils.computeTLBytesSerializedSize(this.newSalt);
        }
        if ((this.flags & 1) != 0) {
            size += TLObjectUtils.computeTLBytesSerializedSize(this.newPasswordHash);
        }
        if ((this.flags & 1) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.hint);
        }
        if ((this.flags & 2) != 0) {
            size += TLObjectUtils.computeTLStringSerializedSize(this.email);
        }
        return size;
    }

    public String toString() {
        return "account.passwordInputSettings#bcfc532c";
    }

    @Override
    public int getConstructorId() {
        return -1124314324;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TLPasswordInputSettings)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        TLPasswordInputSettings o = (TLPasswordInputSettings)object;
        return this.flags == o.flags && (this.newSalt == o.newSalt || this.newSalt != null && o.newSalt != null && this.newSalt.equals(o.newSalt)) && (this.newPasswordHash == o.newPasswordHash || this.newPasswordHash != null && o.newPasswordHash != null && this.newPasswordHash.equals(o.newPasswordHash)) && (this.hint == o.hint || this.hint != null && o.hint != null && this.hint.equals(o.hint)) && (this.email == o.email || this.email != null && o.email != null && this.email.equals(o.email));
    }

    public TLBytes getNewSalt() {
        return this.newSalt;
    }

    public void setNewSalt(TLBytes newSalt) {
        this.newSalt = newSalt;
    }

    public TLBytes getNewPasswordHash() {
        return this.newPasswordHash;
    }

    public void setNewPasswordHash(TLBytes newPasswordHash) {
        this.newPasswordHash = newPasswordHash;
    }

    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

